/*
 * text.1.c
 * Copyright (C) 2011-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))

static int pick_name(const char *, const char **);

static const unsigned c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
pick_name(const char *string, const char **error)
{
    const char *tcstring;
    int escaped = 0, status = 1;

    tcstring = string;

    while (1) {
	int c;

	c = *tcstring;
	if (!c) {
	    break;
	}
	if (!escaped) {
	    if (c == '"') {
		status = 0;
		break;
	    } else {
		if (c == '\\') {
		    escaped = 1;
		}
	    }
	} else {
	    escaped = 0;
	    if (c < '0' || '7' < c) {
	    } else {
		c = tcstring[1];
		if (!c) {
		    break;
		} else {
		    if (c < '0' || '7' < c) {
		    } else {
			tcstring++;
			c = tcstring[1];
			if (!c) {
			    break;
			} else {
			    if (c < '0' || '7' < c) {
			    } else {
				tcstring++;
			    }
			}
		    }
		}
	    }
	}

	tcstring++;
    }

    if (status) {
    } else {
	if (error) {
	    *error = tcstring;
	}

	status = 0;
    }

    return status;
}


int
libx1f4i0_line_text(const char *data, unsigned copy, const char **name,
		    unsigned *size, unsigned *miss)
{
    const char *fail = NULL;
    unsigned last = 1, late = 0, line = 0;

    while (copy) {
	if (*data == 10) {
	    late = 1;
	    line++;
	} else {
	    if (late) {
		if (*data == 35) {
		    fail = data;
		    last = line;
		}
	    }

	    late = 0;
	}

	copy--;
	data++;
    }

    if (fail) {
	do {
	    const char *deck;
	    int c;
	    unsigned slip = 0, tick;

	    do {
		fail++;
		c = *(const unsigned char *) fail;
	    } while (!C_TYPE_X(c_type_4, c));

	    if (C_TYPE_X(c_type_4, c)) {
	    } else {
		break;
	    }

	    do {
		fail++;
		c = *(const unsigned char *) fail;
	    } while (C_TYPE_X(c_type_4, c));

	    if (C_TYPE_X(c_type_2, c)) {
	    } else {
		break;
	    }

	    do {
		slip *= 10;
		slip += c - 48;
		fail++;
		c = *(const unsigned char *) fail;
	    } while (C_TYPE_X(c_type_2, c));

	    if (C_TYPE_X(c_type_4, c)) {
	    } else {
		break;
	    }

	    do {
		fail++;
		c = *(const unsigned char *) fail;
	    } while (C_TYPE_X(c_type_4, c));

	    if (c ^ 34) {
		break;
	    }

	    fail++;

	    if (pick_name(fail, &deck)) {
		break;
	    }

	    {
		c = *(const unsigned char *) deck;
	    }

	    if (c ^ 34) {
		break;
	    }

	    line -= last;
	    line += slip;
	    line -= 2;

	    tick = deck - fail;
	    if (tick ^ 7) {
		*name = fail;
		*size = tick;
	    } else {
		if (memcmp(fail, "<stdin>", 7)) {
		    *name = fail;
		    *size = tick;
		}
	    }
	} while (0);
    }

    *miss = line;

    return 0;
}
