/*
 * sets.0.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>

#include <aime.h>

int
libx1f4i0_join_sets(const struct x1f4_operator_type *const **v16,
		    const struct x1f4_operator_type *const *x1f4,
		    const struct x1f4_operator_type *const *ev16,
		    unsigned class)
{
    const struct x1f4_operator_type **data, *const *z1f4;
    int status = 0;
    unsigned count;

    z1f4 = x1f4;
    while (*z1f4) {
	z1f4++;
    }

    count = z1f4 - x1f4;
    data = (const struct x1f4_operator_type **) malloc
	(sizeof(const struct x1f4_operator_type *) * (class + count + 1));
    if (!data) {
	status = 1;
	*v16 = x1f4;
    } else {
	*v16 = data;
	memcpy(data, ev16,
	       sizeof(const struct x1f4_operator_type *) * class);
	data += class;
	memcpy(data, x1f4,
	       sizeof(const struct x1f4_operator_type *) * (count + 1));
    }

    return status;
}
