/*
 * real.0.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stdio.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
# include <real.h>
#endif				/* !HAVE_LIBx1f4i0 */

int
libx1f4i0_lead_real(const char *self, const char *text, unsigned i, void *aime)
{
    X1f4_E4_C_REAL *slip;
    int status;
    double real;

    status = x1f4_parse_real(&real, text, NULL);
    if (status) {
	char sx[3];

	x1f4_extend_ordinal(sx, i);
	sx[2] = 0;
	fprintf(stderr, "%s: cannot parse value specification for %u%s varia"
		"ble: `%s'\n", self, i + 1, sx, text);
    } else {
	status = 0;

	slip = aime;
	*slip = real;
    }

    return status;
}
