/*
 * miss.0.c
 * Copyright (C) 2007-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4l0
# include <libx1f4l0.h>
# include <stdio.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
# include <as.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
int
libx1f4i0_init_valist(void **valist, int do_memory, int do_storage)
{
    if (!(do_memory | do_storage)) {
# if __BALIST_ONLY__
	x1f4_init_balist(valist);
# else
	x1f4_init_valist(valist, 1024);
# endif				/* __BALIST_ONLY__ */
    } else {
# if __USE_BALIST__
	x1f4_init_balist(valist);
# else
	x1f4_init_xalist(valist);
# endif				/* __USE_BALIST__ */
    }

    return 0;
}
#endif				/* HAVE_LIBx1f4l0 */
