/*
 * list.0.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <ckeytree.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <inter.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <types.h>

static const struct x1f4_ckeytree_type type_0[] = {
/* *INDENT-OFF* */
    {	"cardinal",	{	X1f4_E4_BILL	},	NULL	},
    {	"integer",	{	X1f4_E4_MODE	},	NULL	},
    {	"real",		{	X1f4_E4_REAL	},	NULL	},
    {	"text",		{	X1f4_E4_TEXT	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, type_root[] = {
/* *INDENT-OFF* */
    {	"",		{	0		},	type_0	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
};

int
libx1f4i0_lead_list(const char *self, int argc, char **argv, int optind,
		    void **list, void ***aime, unsigned *class)
{
    int status;
    unsigned count;

    count = (argc - optind) / 3;
    if (!count) {
	status = 0;

	*class = 0;

	*list = NULL;
    } else {
	struct x1f4_variable_type *variable_data;
	void *state;

	variable_data = (struct x1f4_variable_type *)
	    malloc((sizeof(struct x1f4_variable_type) + sizeof(void *)
		    + sizeof(struct lead_type)) * count
		   + sizeof(struct x1f4_variable_type));
	if (!variable_data) {
	    status = -1;
	} else {
	    struct x1f4_variable_type *slide1;
	    struct lead_type *slide3;
	    unsigned i;
	    void **slide2;

	    slide1 = variable_data;
	    slide2 = (void **) (slide1 + count + 1);
	    slide3 = (struct lead_type *) (slide2 + count);

	    state = slide2;

	    for (i = count; i; i--) {
		int status;
		unsigned type;

		status = x1f4_find_ctkey(argv[optind], type_root, &type);
		if (status) {
		    char sx[3];

		    x1f4_extend_ordinal(sx, count - i);
		    sx[2] = 0;
		    fprintf(stderr, "%s: cannot parse type specifica"
			    "tion for %u%s variable: `%s'\n", self,
			    count - i + 1, sx, argv[optind]);
		    break;
		}

		optind++;

		status = libx1f4i0_miss_list
		    (self, argv[optind], count - i, variable_data);
		if (status) {
		    break;
		}

		slide1->name = argv[optind];
		slide1->length = strlen(argv[optind]);

		optind++;

		status = libx1f4i0_lead_data
		    (self, argv[optind], type, count - i, &slide3->data);
		if (status) {
		    break;
		}

		optind++;

		slide1->type = type;
		slide1->flags = 0;

		*slide2 = slide3;

		slide1++;
		slide2++;
		slide3++;
	    }

	    if (i) {
		free(variable_data);

		status = -1;
	    } else {
		status = 0;

		slide1->name = NULL;

		*class = count;

		*aime = state;
		*list = variable_data;
	    }
	}
    }

    return status;
}
