/*
 * line.2.c
 * Copyright (C) 2007-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <aime.h>
#include <line.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

static int oline(void *, void *, void **);
static int opair(void *, void *, void **);
static int oquad(void *, void *, void **);

static void fprint_line(FILE *, unsigned, struct line_type *);

static const int c_____l__[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE
/* *INDENT-ON* */
}, c_____p__[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____q__[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD
/* *INDENT-ON* */
};

const struct x1f4_function_type _libx1f4i0_e4_line_io[] = {
/* *INDENT-OFF* */
    {	"oline",		oline,
	X1f4_E4_VOID,		c_____l__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"opair",		opair,
	X1f4_E4_VOID,		c_____p__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"oquad",		oquad,
	X1f4_E4_VOID,		c_____q__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
oline(void *context, void *output, void **input)
{
    fprint_line(stdout, 8, I_USER(input[0]));

    return 0;
}


static int
opair(void *context, void *output, void **input)
{
    fprint_line(stdout, 2, I_USER(input[0]));

    return 0;
}


static int
oquad(void *context, void *output, void **input)
{
    fprint_line(stdout, 4, I_USER(input[0]));

    return 0;
}


static void
fprint_line(FILE *file, unsigned count, struct line_type *line_data)
{
    long *data;

    data = line_data->data;
    fprintf(file, "%ld", *data);
    --count;
    for (; count; count--) {
	data++;
	fprintf(file, " %ld", *data);
    }
}
