/*
 * io.c
 * Copyright (C) 2002-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <float1.h>
# include <lintegral.f.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_REAL(r)			(*((X1f4_E4_C_REAL *) (r)))
#define I_TEXT(r)			(*((X1f4_E4_C_TEXT *) (r)))

static int obyte(void *, void *, void **);
static int omode(void *, void *, void **);
static int oreal(void *, void *, void **);
static int otext(void *, void *, void **);

static const int c_____m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL
/* *INDENT-ON* */
}, c_____t__[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
};

const struct x1f4_function_type _libx1f4i0_e4_io[] = {
/* *INDENT-OFF* */
    {	"obyte",		obyte,
	X1f4_E4_VOID,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"omode",		omode,
	X1f4_E4_VOID,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"oreal",		oreal,
	X1f4_E4_VOID,		c_____r__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"otext",		otext,
	X1f4_E4_VOID,		c_____t__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
obyte(void *context, void *output, void **input)
{
    fputc(I_MODE(input[0]), stdout);

    return 0;
}


static int
omode(void *context, void *output, void **input)
{
    x1f4_fprint_lintegral(stdout, 0, 10, I_MODE(input[0]));

    return 0;
}


static int
oreal(void *context, void *output, void **input)
{
    x1f4_fprint_wfloat(stdout, 0, 0, 6, I_REAL(input[0]));

    return 0;
}


static int
otext(void *context, void *output, void **input)
{
    fputs(I_TEXT(input[0]), stdout);

    return 0;
}
