/*
 * inter.h
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4i0_INTER_H__
#define __LIBx1f4i0_INTER_H__

#include <config.h>

extern int libx1f4i0_cell_text
    (const char *, const char *, const void *, void **);
extern int libx1f4i0_copy_data(int, unsigned, unsigned, void *);
extern int libx1f4i0_fini_list(const char *, void **);
#if defined HAVE_LIBx1f4l0
extern int libx1f4i0_fini_valist(const char *, void *, int, int, int *);
#endif				/* HAVE_LIBx1f4l0 */
extern int libx1f4i0_free_data(void *, void *);
extern int libx1f4i0_init_fine
    (int, int, char **, unsigned *, void **, void **);
extern int libx1f4i0_init_list
    (const char *, int, char **, int, void **, void ***);
#if defined HAVE_LIBx1f4l0
extern int libx1f4i0_init_valist(void **, int, int);
#endif				/* HAVE_LIBx1f4l0 */
extern int libx1f4i0_lead_bill(const char *, const char *, unsigned, void *);
extern int libx1f4i0_lead_data
    (const char *, const char *, int, unsigned, void *);
extern int libx1f4i0_lead_list
    (const char *, int, char **, int, void **, void ***, unsigned *);
extern int libx1f4i0_lead_mode(const char *, const char *, unsigned, void *);
extern int libx1f4i0_lead_real(const char *, const char *, unsigned, void *);
#if defined HAVE_LIBx1f4l0
extern int libx1f4i0_lead_valist(void *, int, int, void *, void *);
#endif				/* HAVE_LIBx1f4l0 */
extern int libx1f4i0_line_data(int, unsigned, void *);
extern int libx1f4i0_line_text
    (const char *, unsigned, const char **, unsigned *, unsigned *);
#if defined HAVE_LIBx1f4l0
extern int libx1f4i0_line_valist
    (void *, int, int, int (**) (void *, void *),
     int (**) (void *, void **, unsigned),
     int (**) (void *, void **, unsigned), void **, void *);
#endif				/* HAVE_LIBx1f4l0 */
extern int libx1f4i0_link_data(void *, void **, unsigned);
extern int libx1f4i0_miss_list(const char *, const char *, unsigned, void *);
extern int libx1f4i0_miss_name
    (const char *, const char *, const char *, unsigned, void *);
extern int libx1f4i0_mode_data(void *, void **, unsigned);
extern int libx1f4i0_post_data(int, unsigned, void *);
extern int libx1f4i0_read_dash(void **, unsigned *, unsigned);
extern int libx1f4i0_read_file(void **, unsigned *, const char *, unsigned);
extern int libx1f4i0_stat_failure(const char *, int, const char *);
extern int libx1f4i0_type_data(int, unsigned, void *);

#endif				/* __LIBx1f4i0_INTER_H__ */
