/*
 * file.c
 * Copyright (C) 2005-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/types.h>

#include <defs.h>

int
libx1f4i0_read_file(void **data, unsigned *size, const char *path,
		    unsigned extra)
{
    int fd, status = 0;

    fd = open(path, O_RDONLY);
    if (fd == -1) {
	status = LIBx1f4i0_OPEN_FAILURE;
    } else {
	do {
	    char *text;
	    struct stat info;

	    if (fstat(fd, &info)) {
		status = LIBx1f4i0_STAT_FAILURE;
		break;
	    }

	    if (!S_ISREG(info.st_mode)) {
		status = LIBx1f4i0_TEXT_FAILURE;
		break;
	    }

	    text = (char *) malloc(info.st_size + extra);
	    if (!text) {
		status = LIBx1f4i0_LACK_FAILURE;
		break;
	    } else {
		status = read(fd, text, info.st_size);
		if (status != (int) info.st_size) {
		    if (status < 0) {
			status = LIBx1f4i0_READ_FAILURE;
		    } else {
			status = LIBx1f4i0_MISS_FAILURE;
		    }

		    free(text);
		} else {
		    status = 0;

		    *data = text;
		    if (size) {
			*size = info.st_size;
		    }
		}
	    }
	} while (0);

	close(fd);
    }

    return status;
}
