/*
 * ex19.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_FEATURES_H
# include <features.h>
#endif				/* HAVE_FEATURES_H */

#include <getopt.h>
#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#if defined HAVE_LIBx1f4l0
# include <libx1f4l0.h>
#endif				/* HAVE_LIBx1f4l0 */
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <cardinal-wx.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <f2.h>
#if !defined HAVE_LIBx1f4i0
# include <float1.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <inter.h>
#include <sf.h>
#include <types.h>

#define __SLIP_EXPRESSION__		0

#define __COPY_DATA__			1

#define BASE_TYPE			131072

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

typedef struct context_type {
    struct x1f4_variable_type *variable_data;
    void **state;
} context_type;

static int c19xx_f_f(void *, void **);
static int fix_text(const void *, const struct x1f4_function_type *, void **);
static int link_ex19(void);
#if __SLIP_EXPRESSION__
static int link_expression(void *, void *, void *);
#endif				/* __SLIP_EXPRESSION__ */
static int pick_i100(void *, void *, void **);
static int pick_i101(void *, void *, void **);
static int pick_i200(void *, void *, void **);
static int pick_i201(void *, void *, void **);
static int pick_i202(void *, void *, void **);
static int pick_i300(void *, void *, void **);
static int pick_i301(void *, void *, void **);
static int pick_i400(void *, void *, void **);
static int pick_i401(void *, void *, void **);
static int pick_i_i1(void *, void *, void **);
static int pick_i_i2(void *, void *, void **);
static int pick_i_i3(void *, void *, void **);
static int pick_i_i4(void *, void *, void **);
static int pick_i_j2(void *, void *, void **);
static int pick_i_j3(void *, void *, void **);
static int pick_i_l2(void *, void *, void **);
static int pick_i_l3(void *, void *, void **);
static int select_variable(const char *, unsigned, const void *,
			   const struct x1f4_variable_type **, void **);
static int test_cast(void *, const char *, unsigned);
static int type_ex19(void *, void *);

static void usage(void);

static const int c_____f_f[] = {
/* *INDENT-OFF* */
    X1f4_E4_CALL,
    X1f4_E4_CALL
/* *INDENT-ON* */
}, i100_args[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    BASE_TYPE + 1
/* *INDENT-ON* */
}, i101_args[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    BASE_TYPE + 2
/* *INDENT-ON* */
}, mode_args[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
};
static struct x1f4_linetext_type e19a_set[] = {
/* *INDENT-OFF* */
    {	{	"I_i1",			pick_i_i1,
		X1f4_E4_MODE,		mode_args,	1,
		0,					4	},
	NULL								},
    {	{	"I_i2",			pick_i_i2,
		X1f4_E4_MODE,		mode_args,	2,
		0,					4	},
	NULL								},
    {	{	"I_i2b",		pick_i_j2,
		X1f4_E4_MODE,		mode_args,	2,
		0,					5	},
	NULL								},
    {	{	"I_i2c",		pick_i_l2,
		X1f4_E4_MODE,		mode_args,	2,
		0,					5	},
	NULL								},
    {	{	"I_i3",			pick_i_i3,
		X1f4_E4_MODE,		mode_args,	3,
		0,					4	},
	NULL								},
    {	{	"I_i4",			pick_i_i4,
		X1f4_E4_MODE,		mode_args,	4,
		0,					4	},
	NULL								},
    {	{	"I_i_ifi1",		pick_i100,
		X1f4_E4_MODE,		i100_args,	2,
		0,					8	},
	NULL								},
    {	{	"I_i2_ifi2",		pick_i101,
		X1f4_E4_MODE,		i101_args,	3,
		0,					9	},
	NULL								},
    {	{	"I2_i",			pick_i200,
		X1f4_E4_MODE,		mode_args,	1,
		0,					4	},
	NULL								},
    {	{	"I2",			pick_i201,
		X1f4_E4_MODE,		NULL,		0,
		0,					2	},
	NULL								},
    {	{	"I3",			pick_i202,
		X1f4_E4_MODE,		NULL,		0,
		0,					2	},
	NULL								},
    {	{	"I3_i_i",		pick_i300,
		X1f4_E4_MODE,		mode_args,	2,
		0,					6	},
	NULL								},
    {	{	"I_i3b",		pick_i_j3,
		X1f4_E4_MODE,		mode_args,	3,
		0,					5	},
	NULL								},
    {	{	"I_i3c",		pick_i_l3,
		X1f4_E4_MODE,		mode_args,	3,
		0,					5	},
	NULL								},
    {	{	"I3_i2_i",		pick_i301,
		X1f4_E4_MODE,		mode_args,	1,
		0,					7	},
	NULL								},
    {	{	"Quarter",		pick_i400,
		X1f4_E4_MODE,		mode_args,	1,
		X1f4_E4_TEXT_LINK,			7	},
	NULL								},
    {	{	"Half",			pick_i400,
		X1f4_E4_MODE,		mode_args,	1,
		X1f4_E4_TEXT_LINK,			4	},
	NULL								},
    {	{	"Double",		pick_i400,
		X1f4_E4_MODE,		mode_args,	1,
		X1f4_E4_TEXT_LINK,			6	},
	NULL								},
    {	{	"Select",		pick_i401,
		X1f4_E4_MODE,		mode_args,	1,
		0,					6	},
	NULL								},
    {	{	NULL,			NULL,
		0,			NULL,		0,
		0,					1	},
	NULL								}
/* *INDENT-ON* */
};
static const struct x1f4_operator_type e19xx_f_f[] = {
/* *INDENT-OFF* */
    {	"=",			c19xx_f_f,	0400,
	X1f4_E4_CALL,		c_____f_f,
	X1f4_E4_CALL_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, *ex19_e4_2_arithmetics[] = {
/* *INDENT-OFF* */
    e19xx_f_f
/* *INDENT-ON* */
};
static struct x1f4_variable_type e19b_set[] = {
/* *INDENT-OFF* */
    {	"i_i1",			BASE_TYPE,
	0,					4		},
    {	"i_i2",			BASE_TYPE,
	0,					4		},
    {	"i_i2b",		BASE_TYPE,
	0,					5		},
    {	"i_i2c",		BASE_TYPE,
	0,					5		},
    {	"i_i3",			BASE_TYPE,
	0,					4		},
    {	"i_i4",			BASE_TYPE,
	0,					4		},
    {	"i_i_ifi1",		BASE_TYPE,
	0,					8		},
    {	"i_i2_ifi2",		BASE_TYPE,
	0,					9		},
    {	"i2_i",			BASE_TYPE,
	0,					4		},
    {	"i2",			BASE_TYPE,
	0,					2		},
    {	"i3",			BASE_TYPE,
	0,					2		},
    {	"i3_i_i",		BASE_TYPE,
	0,					6		},
    {	"i_i3b",		BASE_TYPE,
	0,					5		},
    {	"i_i3c",		BASE_TYPE,
	0,					5		},
    {	"i3_i2_i",		BASE_TYPE,
	0,					7		},
    {	"quarter",		BASE_TYPE,
	0,					7		},
    {	"half",			BASE_TYPE,
	0,					4		},
    {	"double",		BASE_TYPE,
	0,					6		},
    {	"select",		BASE_TYPE,
	0,					6		},
    {	NULL,			0,
	0,					1		}
/* *INDENT-ON* */
};
static void *e4fine = NULL;
static const void *e19c_set[] = {
/* *INDENT-OFF* */
    e19a_set + 0,
    e19a_set + 1,
    e19a_set + 2,
    e19a_set + 3,
    e19a_set + 4,
    e19a_set + 5,
    e19a_set + 6,
    e19a_set + 7,
    e19a_set + 8,
    e19a_set + 9,
    e19a_set + 10,
    e19a_set + 11,
    e19a_set + 12,
    e19a_set + 13,
    e19a_set + 14,
    e19a_set + 15,
    e19a_set + 16,
    e19a_set + 17,
    e19a_set + 18
/* *INDENT-ON* */
};

static int
c19xx_f_f(void *output, void **input)
{
    X1f4_E4_C_USER user;

    user = I_USER(input[1]);

    l_USER(user, output);
    l_USER(user, input[0]);

    return 0;
}


static int
fix_text(const void *context, const struct x1f4_function_type *function_data,
	 void **link)
{
    *link = (void *) function_data;

    return 0;
}


static int
link_ex19(void)
{
    e19a_set[15].context = &e19a_set[15].function;
    e19a_set[16].context = &e19a_set[16].function;
    e19a_set[17].context = &e19a_set[17].function;

    return 0;
}


#if __SLIP_EXPRESSION__
static int
link_expression(void *expression, void *context, void *output)
{
    int status;
    void *slip;

    status = x1f4_head_expression(expression, &slip);
    if (status) {
    } else {
	int excess, slipping;

	while (1) {
	    struct x1f4_transfer_type transfer;

	    status = x1f4_slip_expression
		(expression, slip, context, 0, &slipping, output, &transfer);
	    if (status) {
		break;
	    } else {
		if (slipping) {
		    if (transfer.function_data->flags & X1f4_E4_TEXT_LINK) {
			status = transfer.function_data->function
			    (transfer.context, transfer.output,
			     transfer.input);
		    } else {
			status = transfer.function_data->function
			    (NULL, transfer.output, transfer.input);
		    }

		    if (status) {
			break;
		    }
		} else {
		    break;
		}
	    }
	}

	excess = x1f4_tail_expression(expression, &slip);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
#endif				/* __SLIP_EXPRESSION__ */


static int
pick_i100(void *text, void *output, void **input)
{
    const struct x1f4_function_type *function_data;

    function_data = I_USER(input[1]);

    if (function_data->flags & X1f4_E4_TEXT_LINK) {
	void *mare;

	fix_text(NULL, function_data, &mare);

	function_data->function(mare, output, input);
    } else {
	function_data->function(NULL, output, input);
    }

    return 0;
}


static int
pick_i101(void *text, void *output, void **input)
{
    const struct x1f4_function_type *function_data;

    function_data = I_USER(input[2]);

    if (function_data->flags & X1f4_E4_TEXT_LINK) {
	void *mare;

	fix_text(NULL, function_data, &mare);

	function_data->function(mare, output, input);
    } else {
	function_data->function(NULL, output, input);
    }

    return 0;
}


static int
pick_i200(void *text, void *output, void **input)
{
    void *logic;

    switch (I_MODE(input[0])) {
    case 0:
	logic = e19a_set + 1;
	break;
    case 1:
	logic = e19a_set + 2;
	break;
    default:
	logic = e19a_set + 3;
    }

    l_USER(logic, output);

    return 0;
}


static int
pick_i201(void *text, void *output, void **input)
{
    l_USER(e19a_set + 1, output);

    return 0;
}


static int
pick_i202(void *text, void *output, void **input)
{
    l_USER(e19a_set + 4, output);

    return 0;
}


static int
pick_i300(void *text, void *output, void **input)
{
    void *logic;

    switch (I_MODE(input[0]) + I_MODE(input[1])) {
    case 0:
	logic = e19a_set + 4;
	break;
    case 1:
	logic = e19a_set + 12;
	break;
    default:
	logic = e19a_set + 13;
    }

    l_USER(logic, output);

    return 0;
}


static int
pick_i301(void *text, void *output, void **input)
{
    l_USER(e19a_set + 11, output);

    return 0;
}


static int
pick_i400(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE i400;
    const struct x1f4_linetext_type *linetext_data;

    i400 = I_MODE(input[0]);

    linetext_data = context;
    switch (linetext_data - e19a_set) {
    case 15:
	i400 /= 4;
	break;
    case 16:
	i400 /= 2;
	break;
    default:
	i400 *= 2;
    }

    l_MODE(i400, output);

    return 0;
}


static int
pick_i401(void *text, void *output, void **input)
{
    X1f4_E4_C_MODE i401;

    i401 = I_MODE(input[0]);

    l_USER(e19a_set + 15 + ((unsigned) i401 < 2 ? i401 : 2), output);

    return 0;
}


static int
pick_i_i1(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]), output);

    return 0;
}


static int
pick_i_i2(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) + I_MODE(input[1]), output);

    return 0;
}


static int
pick_i_i3(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) + I_MODE(input[1]) + I_MODE(input[2]), output);

    return 0;
}


static int
pick_i_i4(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) + I_MODE(input[1]) + I_MODE(input[2])
	   + I_MODE(input[3]), output);

    return 0;
}


static int
pick_i_j2(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) * I_MODE(input[1]), output);

    return 0;
}


static int
pick_i_j3(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) | I_MODE(input[1]) | I_MODE(input[2]), output);

    return 0;
}


static int
pick_i_l2(void *text, void *output, void **input)
{
    X1f4_E4_C_MODE f, s, x;

    f = I_MODE(input[0]);
    s = I_MODE(input[1]);

    x = f;

    if (s < 1) {
    } else {
	if (s < 128) {
	    for (--s; s; s--) {
		x *= f;
	    }
	}
    }

    l_MODE(x, output);

    return 0;
}


static int
pick_i_l3(void *text, void *output, void **input)
{
    l_MODE(I_MODE(input[0]) & I_MODE(input[1]) & I_MODE(input[2]), output);

    return 0;
}


static int
select_variable(const char *f, unsigned length, const void *context,
		const struct x1f4_variable_type **variable, void **state)
{
    int status = X1f4_E4_PARSE_ERROR;
    const struct context_type *context_data;
    const struct x1f4_variable_type *variable_data;

    context_data = context;
    variable_data = context_data->variable_data;
    if (variable_data) {
	while (variable_data->name) {
	    if (length == variable_data->length
		&& !memcmp((void *) f, variable_data->name, length)) {
		break;
	    }
	    variable_data++;
	}
	if (variable_data->name) {
	    status = 0;
	    *state = context_data->state
		[variable_data - context_data->variable_data];
	    *variable = variable_data;
	} else {
	}
    }
    if (status && e4fine) {
	variable_data = e19b_set;
	while (variable_data->name) {
	    if (length == variable_data->length
		&& !memcmp((void *) f, variable_data->name, length)) {
		break;
	    }
	    variable_data++;
	}
	if (variable_data->name) {
	    status = 0;
	    *state = e19c_set + (variable_data - e19b_set);
	    *variable = variable_data;
	} else {
	}
    }

    return status;
}


static int
test_cast(void *cast, const char *name, unsigned size)
{
    return 1 ^ fwrite(name, size, 1, cast);
}


static int
type_ex19(void *self, void *e4fine)
{
    int status = 0;
    const struct x1f4_linetext_type *linetext_data;
    struct x1f4_variable_type *variable_data;
    unsigned index = 0;

    variable_data = e19b_set;
    linetext_data = e19a_set;
    while (linetext_data->function.name) {
	status = x1f4_type_e4fine(e4fine, &variable_data->type, linetext_data);
	if (status) {
	    break;
	} else {
	    if (index ^ 1) {
		if (index ^ 4) {
		    if (index ^ 11) {
			if (index) {
			} else {
			    e19a_set[18].function.type = variable_data->type;
			}
		    } else {
			e19a_set[14].function.type = variable_data->type;
		    }
		} else {
		    e19a_set[10].function.type = variable_data->type;
		    e19a_set[11].function.type = variable_data->type;
		}
	    } else {
		e19a_set[8].function.type = variable_data->type;
		e19a_set[9].function.type = variable_data->type;
	    }

	    index++;
	    linetext_data++;
	    variable_data++;
	}
    }

    return status;
}


static void
usage(void)
{
    puts("Usage: ex19 [OPTIONS] EXPRESSION [TYPE NAME VALUE]\n\
Evaluate EXPRESSION.\n\
\n\
Options:\n\
  -M, --stat-storage		stat expression memory storage requirements\n\
  -P, --print			print expression\n\
  -m, --stat-memory		stat memory operations\n\
  -o, --optimize		enable optimizations\n\
  -p, --precision DIGITS	set precision for printing reals to DIGITS\n\
      --detail-constants	detail constants when printing expression\n\
      --detail-operators	detail operators when printing expression\n\
      --help			display this help and exit\n\
      --version			output version information and exit");
}


int
main(int argc, char **argv)
{
    int do_memory = 0, do_optimize = 0, do_print = 0, do_storage = 0,
	list_functions = 0, status = 1;
    unsigned precision = 3, print_flags = 0;

    unsetenv("POSIXLY_CORRECT");

    {
	char *precision_specs = NULL;

	while (1) {
	    char c;
	    static struct option long_options[] = {
/* *INDENT-OFF* */
		{   "detail-constants",
				    0x00,   NULL,   0x12    },
		{   "detail-operators",
				    0x00,   NULL,   0x11    },
		{   "help",	    0x00,   NULL,   0x68    },
		{   "optimize",	    0x00,   NULL,   0x6f    },
		{   "stat-memory",  0x00,   NULL,   0x6d    },
		{   "stat-storage", 0x00,   NULL,   0x4d    },
		{   "version",	    0x00,   NULL,   0x76    },
		{   "precision",    0x01,   NULL,   0x70    },
		{   "print",	    0x00,   NULL,   0x50    },
		{   NULL,	    0x00,   NULL,   0x00    }
/* *INDENT-ON* */
	    };

	    c = getopt_long(argc, argv, "MPmop:", long_options, NULL);

	    if (!~c) {
		break;
	    }

	    switch (c) {
	    case 021:
		print_flags |= X1f4_E4_DETAIL_OPERATORS;
		break;
	    case 022:
		print_flags |= X1f4_E4_DETAIL_CONSTANTS;
		break;
	    case 'M':
		do_storage = 1;
		break;
	    case 'P':
		do_print = 1;
		break;
	    case 'm':
		do_memory = 1;
		break;
	    case 'o':
		do_optimize = 1;
		break;
	    case 'p':
		precision_specs = optarg;
		break;
	    case 'h':
		usage();

		return 0;
	    case 'v':
		printf("%s (%s) %s\n", argv[0], PACKAGE, VERSION);

		return 0;
	    case '?':
		return 1;
	    }
	}

	if (list_functions) {
	    precision_specs = NULL;
	}

	if (do_print) {
	    precision_specs = NULL;
	}

	if (precision_specs) {
	    if (x1f4_parse_wxcardinal(&precision, precision_specs, NULL, 0)) {
		fprintf(stderr, "%s: cannot parse precision specification: `"
			"%s'\n", argv[0], precision_specs);

		return 1;
	    }
	}
    }

    if ((argc - optind) % 3 != 1) {
	fprintf(stderr, "%s: wrong number of arguments\nType `%s --help' for"
		" more information.\n", argv[0], argv[0]);
    } else {
	do {
	    const char *expression;
#if defined HAVE_LIBx1f4l0
	    struct list_type dlist;
#endif				/* HAVE_LIBx1f4l0 */
	    struct x1f4_eerecord_type eerecord;
	    const struct x1f4_operator_type *const *e4_2_arithmetics,
		*const *operator2s;
	    struct x1f4_variable_type *variable_data;
	    unsigned flags = X1f4_E4_DDACCESS;
	    void **state = NULL, *x1f4_expression;
#if defined HAVE_LIBx1f4l0
	    void *valist = NULL;
#endif				/* HAVE_LIBx1f4l0 */

	    expression = argv[optind];
	    optind++;

	    status = libx1f4i0_init_list
		(argv[0], argc, argv, optind, (void *) &variable_data, &state);
	    if (status) {
		break;
	    }

#if defined HAVE_LIBx1f4l0
	    libx1f4i0_init_valist(&valist, do_memory, do_storage);
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
	    if (valist) {
		struct x1f4_e4fine_type pick_fine;

		if (1) {
		    libx1f4i0_line_valist
			(valist, do_memory, do_storage,
			 &pick_fine.resource_set.free,
			 &pick_fine.resource_set.link,
			 &pick_fine.resource_set.mode,
			 &pick_fine.resource_set.data, &dlist);
		}

		x1f4_init_e4fine(&e4fine, X1f4_E4FINE_RESOURCE, &pick_fine);
	    } else {
#endif				/* HAVE_LIBx1f4l0 */
		x1f4_init_e4fine(&e4fine, 0, NULL);
#if defined HAVE_LIBx1f4l0
	    }
#endif				/* HAVE_LIBx1f4l0 */

	    link_ex19();

	    if (e4fine) {
		if (type_ex19(argv[0], e4fine)) {
		    x1f4_fini_e4fine(&e4fine);
		    if (1) {
			e4fine = NULL;
		    }
		}
	    }

	    x1f4_llink_operator2s(&e4_2_arithmetics);
	    libx1f4i0_join_sets
		(&operator2s, e4_2_arithmetics, ex19_e4_2_arithmetics, 1);

	    {
		struct context_type context;
		struct x1f4_attributes_type attributes;

		context.state = state;
		context.variable_data = variable_data;

		attributes.bcollect_set.eerecord_data = &eerecord;
		attributes.function_set.fix = fix_text;
		attributes.function_set.get = libx1f4i0_select_function;
		attributes.function_set.context = x1f4_e4_defaults;
		x1f4_llink_operator1s(&attributes.operator1s);
		attributes.operator2s =
		    operator2s ? operator2s : e4_2_arithmetics;
		attributes.terminator = 0;
		attributes.transfer_set.fine = e4fine;
		attributes.variable_set.get = select_variable;
		attributes.variable_set.context = &context;

		flags |= X1f4_E4_BCOLLECT | X1f4_E4_ESTORAGE;

		if (e4fine) {
		    flags |= X1f4_E4_TRANSFER;
		}

#if defined HAVE_LIBx1f4l0
		if (valist) {
		    flags |= X1f4_E4_RESOURCE;
		    libx1f4i0_line_valist
			(valist, do_memory, do_storage,
			 &attributes.resource_set.free,
			 &attributes.resource_set.link,
			 &attributes.resource_set.mode,
			 &attributes.resource_set.context, &dlist);
		}
#endif				/* HAVE_LIBx1f4l0 */

		{
		    status = x1f4_init_expression
			(&x1f4_expression, expression, flags, &attributes);
#if __COPY_DATA__
		    if (status) {
		    } else {
			void *expression;

			status = x1f4_copy_expression
			    (&expression, x1f4_expression);
			if (status) {
			} else {
			    x1f4_fini_expression(&x1f4_expression);
			    x1f4_expression = expression;
			}
		    }
#endif				/* __COPY_DATA__ */
		}
	    }
	    if (status) {
		if (status == X1f4_E4_ALLOC_ERROR) {
		    perror(argv[0]);
		} else {
		    fprintf(stderr, "%s: cannot parse `%s'\n", argv[0],
			    expression);
		    fprintf(stderr, "%s: ", argv[0]);
		    x1f4_stat_expression(stderr, test_cast, &eerecord, NULL);
		    fprintf(stderr, "\n");
		}
	    } else {
		if (do_optimize) {
		    x1f4_line_expression(x1f4_expression);
		}

#if defined HAVE_LIBx1f4l0
		if (valist) {
		    if (do_storage) {
			unsigned size;

			x1f4_size_xalist(valist, &size);
			fprintf(stderr, " %7u\n", size);
		    }
		}
#endif				/* HAVE_LIBx1f4l0 */

		if (do_print) {
		    x1f4_print_expression
			(stdout, x1f4_expression, print_flags);
		    putchar('\n');
		} else {
		    struct lead_type output;

#if __SLIP_EXPRESSION__
		    status = link_expression(x1f4_expression, NULL, &output);
#else
		    status = x1f4_link_expression(x1f4_expression, &output);
#endif				/* __SLIP_EXPRESSION__ */
		    if (status) {
			fprintf(stderr, "%s: cannot evaluate `%s'\n", argv[0],
				expression);
		    } else {
			libx1f4i0_type_data
			    (x1f4_type_expression(x1f4_expression), precision,
			     &output);
		    }
		}

		x1f4_fini_expression(&x1f4_expression);
	    }

	    if (operator2s) {
		free((void *) operator2s);
	    }

	    if (e4fine) {
		x1f4_fini_e4fine(&e4fine);
	    }

#if defined HAVE_LIBx1f4l0
	    if (valist) {
		libx1f4i0_fini_valist
		    (argv[0], valist, do_memory, do_storage, &status);
	    }
#endif				/* HAVE_LIBx1f4l0 */

	    libx1f4i0_fini_list(argv[0], (void *) &variable_data);
	} while (0);
    }

    return status;
}
