/*
 * error.c
 * Copyright (C) 2005-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <stdio.h>
#include <string.h>

#include <defs.h>

static void stat_system(const char *, const char *);
static void stat_xalock(void);
static void stat_xamiss(const char *, const char *);
static void stat_xatext(const char *);

static void
stat_system(const char *call, const char *lock)
{
    fprintf(stderr, "cannot %s `%s': %s", call, lock, strerror(errno));
}


static void
stat_xalock(void)
{
    fprintf(stderr, "%s", strerror(errno));
}


static void
stat_xamiss(const char *call, const char *lock)
{
    fprintf(stderr, "cannot %s `%s'", call, lock);
}


static void
stat_xatext(const char *lock)
{
    fprintf(stderr, "`%s' is not a regular file", lock);
}


int
libx1f4i0_stat_failure(const char *argv_0_, int error, const char *lock)
{
    fprintf(stderr, "%s: ", argv_0_);

    switch (error) {
    case LIBx1f4i0_LACK_FAILURE:
	stat_xalock();
	break;
    case LIBx1f4i0_MISS_FAILURE:
	stat_xamiss("read", lock);
	break;
    case LIBx1f4i0_OPEN_FAILURE:
	stat_system("open", lock);
	break;
    case LIBx1f4i0_READ_FAILURE:
	stat_system("read", lock);
	break;
    case LIBx1f4i0_STAT_FAILURE:
	stat_system("stat", lock);
	break;
    case LIBx1f4i0_TEXT_FAILURE:
	stat_xatext(lock);
    }

    fprintf(stderr, "\n");

    return -1;
}
