/*
 * e4ff.c
 * Copyright (C) 2002-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_FEATURES_H
# include <features.h>
#endif				/* HAVE_FEATURES_H */

#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

#include <aime.h>

static int type_defaults(void *);

static void usage(void);

static int
type_defaults(void *e4fine)
{
    int status = 0;
    const struct x1f4_function_type *function_data;

    function_data = x1f4_e4_defaults;
    while (function_data->name) {
	int type;
	struct x1f4_linetext_type linetext;

	linetext.function = *function_data;

	status = x1f4_type_e4fine(e4fine, &type, &linetext);
	if (status) {
	    break;
	} else {
	    printf("%8d\t", type - X1f4_E4_CALL);
	    x1f4_print_function(stdout, function_data);

	    function_data++;
	}
    }

    return status;
}

static void
usage(void)
{
    puts("Usage: e4ff [OPTIONS]\n\
Test the e4fine function type allocator.\n\
\n\
Options:\n\
  --help			display this help and exit\n\
  --version			output version information and exit");
}


int
main(int argc, char **argv)
{
    int fast = ~0, status = 0;

    unsetenv("POSIXLY_CORRECT");

    while (1) {
	char c;
	static struct option long_options[] = {
/* *INDENT-OFF* */
	    {	"version",	0x00,	NULL,	0x76	},
	    {	"help",		0x00,	NULL,	0x68	},
	    {	NULL,		0x00,	NULL,	0x00	}
/* *INDENT-ON* */
	};

	c = getopt_long(argc, argv, "", long_options, NULL);

	if (!~c) {
	    break;
	}

	switch (c) {
	case 'h':
	case 'v':
	    if (!~fast) {
		fast = c;
	    }
	    break;
	case '?':
	    return 1;
	}
    }

    if (~fast) {
	switch (fast) {
	case 'h':
	    usage();
	    break;
	case 'v':
	    printf("%s (%s) %s\n", argv[0], PACKAGE, VERSION);
	}

	return 0;
    }

    if (0 < argc - optind) {
	fprintf(stderr, "%s: too many arguments\nTry `%s --help' for more in"
		"formation.\n", argv[0], argv[0]);

	return 1;
    } else {
	void *e4fine;

	status = x1f4_init_e4fine(&e4fine, 0, NULL);
	if (status) {
	} else {
	    int excess;

	    status = type_defaults(e4fine);

	    excess = x1f4_fini_e4fine(&e4fine);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
