/*
 * data.0.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <stdio.h>
#include <string.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <lcardinal-x.h>
# include <lintegral-x.h>
# include <ordinal.h>
# include <real.h>
#endif				/* !HAVE_LIBx1f4i0 */

int
libx1f4i0_lead_data(const char *self, const char *text, int type, unsigned i,
		    void *aime)
{
    int status;

    if (type == X1f4_E4_BILL) {
	X1f4_E4_C_BILL *slip;
	unsigned long bill;

	status = x1f4_parse_xlcardinal(&bill, text, NULL, 0);
	if (status) {
	    char sx[3];

	    x1f4_extend_ordinal(sx, i);
	    sx[2] = 0;
	    fprintf(stderr, "%s: cannot parse value specification for %u%s v"
		    "ariable: `%s'\n", self, i + 1, sx, text);
	} else {
	    status = 0;

	    slip = aime;
	    *slip = bill;
	}
    } else {
	if (type == X1f4_E4_MODE) {
	    X1f4_E4_C_MODE *slip;
	    long mode;

	    status = x1f4_parse_xlintegral(&mode, text, NULL, 0);
	    if (status) {
		char sx[3];

		x1f4_extend_ordinal(sx, i);
		sx[2] = 0;
		fprintf(stderr, "%s: cannot parse value specification for %u"
			"%s variable: `%s'\n", self, i + 1, sx, text);
	    } else {
		status = 0;

		slip = aime;
		*slip = mode;
	    }
	} else {
	    if (type == X1f4_E4_REAL) {
		X1f4_E4_C_REAL *slip;
		double real;

		status = x1f4_parse_real(&real, text, NULL);
		if (status) {
		    char sx[3];

		    x1f4_extend_ordinal(sx, i);
		    sx[2] = 0;
		    fprintf(stderr, "%s: cannot parse value specification fo"
			    "r %u%s variable: `%s'\n", self, i + 1, sx, text);
		} else {
		    status = 0;

		    slip = aime;
		    *slip = real;
		}
	    } else {
		X1f4_E4_C_TEXT *slip;

		status = 0;

		slip = aime;
		*slip = (char *) text;
	    }
	}
    }

    return status;
}
