/*
 * vtkey3.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <vtkey-types.h>

int
x1f4_make_vtkeyroot(struct keytree_type **root, const char *name,
		    const void *key)
{
    int status = -1;
    struct keytree_type *keytree_data;

    keytree_data = (struct keytree_type *)
	malloc(sizeof(struct keytree_type) << 1);
    if (keytree_data) {
	char *string;
	unsigned length;

	length = strlen(name) + 1;
	string = (char *) malloc(length);
	if (!string) {
	    free(keytree_data);
	} else {
	    memcpy(string, name, length);

	    keytree_data->children = NULL;
	    keytree_data->data.data = key;
	    keytree_data->string = string;

	    *root = keytree_data;

	    keytree_data[1].string = NULL;

	    status = 0;
	}
    }

    return status;
}
