/*
 * vtkey.h
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_VTKEY_H__
#define __LIBx1f4_VTKEY_H__

#if !defined __x1f4_vkeytree_type_defined__
typedef struct x1f4_vkeytree_type {
    char *string;
    struct {
	const void *data;
    } data;
    const struct x1f4_vkeytree_type *children;
} x1f4_vkeytree_type;
#endif				/* !__x1f4_vkeytree_type_defined__ */

#if !defined __x1f4_vkeytree_type_defined__
# define __x1f4_vkeytree_type_defined__
#endif				/* !__x1f4_vkeytree_type_defined__ */

extern int x1f4_copy_vtkeytree
    (struct x1f4_vkeytree_type **, const struct x1f4_vkeytree_type *);
extern int x1f4_free_vtkeynode
    (struct x1f4_vkeytree_type *, const char *);
extern int x1f4_make_vtkeynode
    (struct x1f4_vkeytree_type **, const char *, const void *);
extern int x1f4_make_vtkeynode_l
    (struct x1f4_vkeytree_type **, const char *, unsigned, const void *);
extern int x1f4_make_vtkeyroot
    (struct x1f4_vkeytree_type **, const char *, const void *);
extern int x1f4_make_vtkeyroot_l
    (struct x1f4_vkeytree_type **, const char *, unsigned, const void *);
extern int x1f4_mode_vtkeynode
    (struct x1f4_vkeytree_type **, const char *, const void *);
extern int x1f4_mode_vtkeynode_l
    (struct x1f4_vkeytree_type **, const char *, unsigned, const void *);

extern void x1f4_free_vtkeydata
    (struct x1f4_vkeytree_type *);

#endif				/* __LIBx1f4_VTKEY_H__ */
