/*
 * vtkey.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <vtkey-types.h>

static int make_node(struct keytree_type **, const char *, const void *);

static int
make_node(struct keytree_type **node, const char *name, const void *key)
{
    const char *string;
    int c, status = 1;
    struct keytree_type *keytree_data;

    keytree_data = *node;

    c = *name;
    string = keytree_data->string;
    if (!c) {
	struct keytree_type *keytree_text;

	keytree_text = keytree_data;
	do {
	    if (*string < 0) {
		keytree_data++;
		string = keytree_data->string;
	    } else {
		break;
	    }
	} while (string);
	if (!string) {
	    char *strIng;

	    strIng = (char *) malloc(1);
	    if (!strIng) {
		status = -1;
	    } else {
		unsigned count;

		*strIng = 0;

		count = keytree_data - keytree_text;
		keytree_data = (struct keytree_type *)
		    malloc((count + 2) * sizeof(struct keytree_type));
		if (!keytree_data) {
		    free(strIng);

		    status = -1;
		} else {
		    memcpy(keytree_data, keytree_text,
			   count * sizeof(struct keytree_type));

		    free(keytree_text);

		    *node = keytree_data;

		    keytree_data += count;

		    keytree_data->children = NULL;
		    keytree_data->data.data = key;
		    keytree_data->string = strIng;

		    keytree_data[1].string = NULL;

		    status = 0;
		}
	    }
	} else if (!*string) {
	} else {
	    char *strIng;

	    strIng = (char *) malloc(1);
	    if (!strIng) {
		status = -1;
	    } else {
		unsigned cOunt, count;

		*strIng = 0;

		count = keytree_data - keytree_text;

		do {
		    keytree_data++;
		    string = keytree_data->string;
		} while (string);
		cOunt = keytree_data - keytree_text;

		keytree_data = (struct keytree_type *)
		    malloc((cOunt + 2) * sizeof(struct keytree_type));
		if (!keytree_data) {
		    free(strIng);

		    status = -1;
		} else {
		    *node = keytree_data;

		    memcpy(keytree_data, keytree_text,
			   count * sizeof(struct keytree_type));

		    keytree_data += count;

		    keytree_data->children = NULL;
		    keytree_data->data.data = key;
		    keytree_data->string = strIng;

		    keytree_data++;

		    cOunt -= count;

		    memcpy(keytree_data, keytree_text + count,
			   cOunt * sizeof(struct keytree_type));

		    free(keytree_text);

		    keytree_data += cOunt;

		    keytree_data[0].string = NULL;

		    status = 0;
		}
	    }
	}
    } else {
	struct keytree_type *keytree_text;

	keytree_text = keytree_data;
	do {
	    if (*string < c) {
		keytree_data++;
		string = keytree_data->string;
	    } else {
		break;
	    }
	} while (string);
	if (!string) {
	    char *strIng;
	    unsigned length;

	    length = strlen(name) + 1;
	    strIng = (char *) malloc(length);
	    if (!strIng) {
		status = -1;
	    } else {
		unsigned count;

		memcpy(strIng, name, length);

		count = keytree_data - keytree_text;
		keytree_data = (struct keytree_type *)
		    malloc((count + 2) * sizeof(struct keytree_type));
		if (!keytree_data) {
		    free(strIng);

		    status = -1;
		} else {
		    memcpy(keytree_data, keytree_text,
			   count * sizeof(struct keytree_type));

		    free(keytree_text);

		    *node = keytree_data;

		    keytree_data += count;

		    keytree_data->children = NULL;
		    keytree_data->data.data = key;
		    keytree_data->string = strIng;

		    keytree_data[1].string = NULL;

		    status = 0;
		}
	    }
	} else if (c != *string) {
	    char *strIng;
	    unsigned length;

	    length = strlen(name) + 1;
	    strIng = (char *) malloc(length);
	    if (!strIng) {
		status = -1;
	    } else {
		unsigned cOunt, count;

		memcpy(strIng, name, length);

		count = keytree_data - keytree_text;

		do {
		    keytree_data++;
		    string = keytree_data->string;
		} while (string);
		cOunt = keytree_data - keytree_text;

		keytree_data = (struct keytree_type *)
		    malloc((cOunt + 2) * sizeof(struct keytree_type));
		if (!keytree_data) {
		    free(strIng);

		    status = -1;
		} else {
		    *node = keytree_data;

		    memcpy(keytree_data, keytree_text,
			   count * sizeof(struct keytree_type));

		    keytree_data += count;

		    keytree_data->children = NULL;
		    keytree_data->data.data = key;
		    keytree_data->string = strIng;

		    keytree_data++;

		    cOunt -= count;

		    memcpy(keytree_data, keytree_text + count,
			   cOunt * sizeof(struct keytree_type));

		    free(keytree_text);

		    keytree_data += cOunt;

		    keytree_data[0].string = NULL;

		    status = 0;
		}
	    }
	} else {
	    do {
		string++;
		name++;
		c = *name;
		if (!c) {
		    break;
		}
	    } while (c == *string);
	    if (*string) {
		char *strlng;
		unsigned lenGth;

		lenGth = strlen(string) + 1;
		strlng = (char *) malloc(lenGth);
		if (!strlng) {
		    status = -1;
		} else {
		    char *strIng;
		    unsigned length;

		    length = strlen(name) + 1;
		    strIng = (char *) malloc(length);
		    if (!strIng) {
			free(strlng);

			status = -1;
		    } else {
			memcpy(strIng, name, length);

			memcpy(strlng, string, lenGth);

			keytree_text = (struct keytree_type *)
			    malloc(sizeof(struct keytree_type) * 3);
			if (!keytree_text) {
			    free(strIng);
			    free(strlng);

			    status = -1;
			} else {
			    keytree_text[2].string = NULL;

			    if (c < *string) {
				keytree_text[0].children = NULL;
				keytree_text[0].data.data = key;
				keytree_text[0].string = strIng;
				keytree_text[1].children =
				    keytree_data->children;
				keytree_text[1].data.data =
				    keytree_data->data.data;
				keytree_text[1].string = strlng;
			    } else {
				keytree_text[0].children =
				    keytree_data->children;
				keytree_text[0].data.data =
				    keytree_data->data.data;
				keytree_text[0].string = strlng;
				keytree_text[1].children = NULL;
				keytree_text[1].data.data = key;
				keytree_text[1].string = strIng;
			    }

			    keytree_data->children = keytree_text;
			    keytree_data->data.data = NULL;

			    strlng = (char *) string;
			    *strlng = 0;

			    strlng = keytree_data->string;
			    lenGth = string - strlng + 1;
			    strlng = (char *) realloc(strlng, lenGth);
			    if (strlng) {
				keytree_data->string = strlng;
			    }

			    status = 0;
			}
		    }
		}
	    } else {
		keytree_text = (struct keytree_type *) keytree_data->children;
		if (keytree_text) {
		    status = make_node(&keytree_text, name, key);
		    if (!status) {
			keytree_data->children = keytree_text;
		    }
		} else {
		    if (!c) {
		    } else {
			char *strlng;

			strlng = (char *) malloc(1);
			if (!strlng) {
			    status = -1;
			} else {
			    char *strIng;
			    unsigned length;

			    length = strlen(name) + 1;
			    strIng = (char *) malloc(length);
			    if (!strIng) {
				free(strlng);

				status = -1;
			    } else {
				memcpy(strIng, name, length);

				*strlng = 0;

				keytree_text = (struct keytree_type *)
				    malloc(sizeof(struct keytree_type) * 3);
				if (!keytree_text) {
				    free(strIng);
				    free(strlng);

				    status = -1;
				} else {
				    keytree_text[2].string = NULL;

				    if (c < 0) {
					keytree_text[0].data.data = key;
					keytree_text[0].string = strIng;
					keytree_text[1].data.data =
					    keytree_data->data.data;
					keytree_text[1].string = strlng;
				    } else {
					keytree_text[0].data.data =
					    keytree_data->data.data;
					keytree_text[0].string = strlng;
					keytree_text[1].data.data = key;
					keytree_text[1].string = strIng;
				    }
				    {
					keytree_text[0].children = NULL;
					keytree_text[1].children = NULL;
				    }

				    keytree_data->children = keytree_text;
				    keytree_data->data.data = NULL;

				    status = 0;
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


int
x1f4_make_vtkeynode(struct keytree_type **root, const char *name,
		    const void *key)
{
    char *string;
    int status;
    struct keytree_type *keytree_data;

    keytree_data = *root;
    string = keytree_data[0].string;
    if (keytree_data[1].string) {
	status = make_node(root, name, key);
    } else {
	if (!string) {
	    char *string;
	    unsigned length;

	    length = strlen(name) + 1;
	    string = (char *) malloc(length);
	    if (!string) {
		status = -1;
	    } else {
		memcpy(string, name, length);

		keytree_data->children = NULL;
		keytree_data->data.data = key;
		keytree_data->string = string;

		status = 0;
	    }
	} else if (!*string) {
	    struct keytree_type *keytree_text;

	    keytree_text = (struct keytree_type *) keytree_data->children;
	    status = make_node(&keytree_text, name, key);
	    if (!status) {
		keytree_data->children = keytree_text;
	    }
	} else if (*string != *name) {
	    string = (char *) malloc(1);
	    if (!string) {
		status = -1;
	    } else {
		struct keytree_type *keytree_text;

		keytree_text = (struct keytree_type *)
		    malloc(sizeof(struct keytree_type) << 1);
		if (!keytree_text) {
		    free(string);

		    status = -1;
		} else {
		    status = make_node(root, name, key);
		    if (status) {
			free(keytree_text);
			free(string);
		    } else {
			keytree_text[0].children = *root;
			keytree_text[0].string = string;
			keytree_text[1].string = NULL;

			*root = keytree_text;

			*string = 0;
		    }
		}
	    }
	} else {
	    status = make_node(root, name, key);
	}
    }

    return status;
}
