/*
 * real.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <float.h>
#include <math.h>

#if defined LIBx1f4i0
# include <ctype.0.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

#if !defined DBL_MANT_DIG
# if SIZEOF_DOUBLE == 8
#  undef FLT_RADIX
#  define FLT_RADIX			2
#  define DBL_MANT_DIG			53
# endif				/* SIZEOF_DOUBLE == 8 */
#endif				/* DBL_MANT_DIG */

#if defined DBL_MANT_DIG
# if defined FLT_RADIX
#  if FLT_RADIX == 2
#   define __USE_DOUBLE_MANTISSA_DIGITS__
#  endif			/* FLT_RADIX == 2 */
# endif				/* FLT_RADIX */
#endif				/* DBL_MANT_DIG */

static const unsigned c_type_1[] = {
/*
 *                   . .     .
 *
 * .                     +
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000801, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_parse_real(double *real, const char *s, const char **e)
{
    const char *t;
    int c, sign = 0, status = 0;

    t = s;
    c = *(const unsigned char *) t;
    do {
	if (c == '-') {
	    sign ^= 1;
	} else if (C_TYPE_X(c_type_1, c)) {
	} else {
	    break;
	}
	t++;
	c = *(const unsigned char *) t;
    } while (1);

    if (c == '.') {
	t++;
	c = *(const unsigned char *) t;
	if (!C_TYPE_X(c_type_2, c)) {
	    status = 1;
	} else {
	    double unit = 0;
#if defined __USE_DOUBLE_MANTISSA_DIGITS__
	    unsigned D;
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
	    unsigned d;

	    s = t;

	    do {
		unit *= 10;
		unit += c - '0';
		t++;
		c = *(const unsigned char *) t;
	    } while (C_TYPE_X(c_type_2, c));
	    if (c) {
		status = 1;
	    }

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
	    D = floor(DBL_MANT_DIG * log(2) / log(10));
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */

	    d = t - s;

	    s = t;

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
	    if (d < D + 1) {
		unit /= pow(10, d);
	    } else {
#elif 0
	    }
#else
	    {
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
		double base = 10;

	        while (d) {
		    if (d & 1) {
			unit /= base;
		    }

		    d >>= 1;

		    base *= base;
		}
	    }

	    if (sign) {
		*real = -unit;
	    } else {
		*real = unit;
	    }
	}
    } else {
	if (!C_TYPE_X(c_type_2, c)) {
	    status = 1;
	} else {
	    double integral = 0;

	    do {
		integral *= 10;
		integral += c - '0';
		t++;
		c = *(const unsigned char *) t;
	    } while (C_TYPE_X(c_type_2, c));
	    if (c != '.') {
		if (c) {
		    status = 1;
		}

		s = t;

		if (sign) {
		    *real = -integral;
		} else {
		    *real = integral;
		}
	    } else {
		t++;
		c = *(const unsigned char *) t;
		if (!C_TYPE_X(c_type_2, c)) {
		    status = 1;

		    s = t - 1;

		    if (sign) {
			*real = -integral;
		    } else {
			*real = integral;
		    }
		} else {
		    double unit = 0;
#if defined __USE_DOUBLE_MANTISSA_DIGITS__
		    unsigned D;
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
		    unsigned d;

		    s = t;

		    do {
			unit *= 10;
			unit += c - '0';
			t++;
			c = *(const unsigned char *) t;
		    } while (C_TYPE_X(c_type_2, c));
		    if (c) {
			status = 1;
		    }

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
		    D = floor(DBL_MANT_DIG * log(2) / log(10));
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */

		    d = t - s;

		    s = t;

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
		    if (d < D + 1) {
			unit /= pow(10, d);
		    } else {
#elif 0
		    }
#else
		    {
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
			double base = 10;

		        while (d) {
			    if (d & 1) {
				unit /= base;
			    }

			    d >>= 1;

			    base *= base;
			}
		    }

		    unit += integral;
		    if (sign) {
			*real = -unit;
		    } else {
			*real = unit;
		    }
		}
	    }
	}
    }

    if (e) {
	*e = s;
    }

    return status;
}
