/*
 * lintegral.f-w.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdio.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lintegral.p.h>
# include <space.f.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)
#define SIGN_SIZE		(BASE_SIZE + 1)

int
x1f4_fprint_wlintegral(FILE *file, int big, unsigned w, unsigned base, long c)
{
    int status;

    do {
	char data[SIGN_SIZE], *mode;
	int excess;
	unsigned size;

	mode = data + SIGN_SIZE;
	x1f4_xprint_lintegral(&mode, big, base, c);

	size = data + SIGN_SIZE - mode;

	if (size < w) {
	    status = x1f4_fprint_space(file, w - size);
	    if (status < 0) {
		break;
	    }
	} else {
	    status = 0;
	}

	excess = fprintf(file, "%.*s", (int) size, mode);
	if (excess < 0) {
	    status = excess;
	} else {
	    status += excess;
	}
    } while (0);

    return status;
}
