/*
 * lintegral.f-fb.c
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.f-fb.h>
#endif				/* !LIBx1f4i0 */

int
x1f4_fprint_fblintegral(FILE *file, int big, unsigned f, unsigned b,
			unsigned base, long c)
{
    int status;

    if (!(c < 0)) {
	status = x1f4_fprint_fblcardinal(file, big, f, b, base, c);
    } else {
	if (putc('-', file) == EOF) {
	    status = -1;
	} else {
	    status = x1f4_fprint_fblcardinal(file, big, f, b, base, -c);
	    if (status < 0) {
	    } else {
		status++;
	    }
	}
    }

    return status;
}
