/*
 * integral-x.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <limits.h>

#if !defined LIBx1f4i0
# include <cardinal-x.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <ctype.0.h>
# include <inter.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

static const unsigned c_type_1[] = {
/*
 *                   . .     .
 *
 * .                     +
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000801, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_parse_xintegral(int *integral, const char *s, const char **e,
		     unsigned base)
{
    const char *f, *t;
    int c, fix = 1, sign = 0, status;
    unsigned cardinal;

    t = s;
    c = *(const unsigned char *) t;
    do {
	if (c == '-') {
	    sign ^= 1;
	} else if (C_TYPE_X(c_type_1, c)) {
	} else {
	    break;
	}
	t++;
	c = *(const unsigned char *) t;
    } while (1);
    status = x1f4_parse_xcardinal(&cardinal, t, &f, base);
    if (status) {
	if (f == t) {
	    fix = 0;
	    if (e) {
		*e = s;
	    }
	} else {
	    if (e) {
		*e = f;
	    }
	}
    } else {
	if (e) {
	    *e = f;
	}
    }
    if (fix) {
	if (!sign) {
	    if (cardinal < (unsigned) INT_MAX) {
		*integral = cardinal;
	    } else {
		*integral = INT_MAX;
	    }
	} else {
#if INT_MAX + INT_MIN < 0
	    int d, i = 0;

	    d = INT_MAX;
	    while (1) {
		if (cardinal < (unsigned) d) {
		    i -= cardinal;
		    break;
		} else {
		    i -= d;
		    cardinal -= d;
		    d = INT_MIN - i;
		    if (!d) {
			break;
		    } else {
			if (-INT_MAX < d) {
			    d = -d;
			} else {
			    d = INT_MAX;
			}
		    }
		}
	    }

	    *integral = i;
#else
	    if (cardinal < (unsigned) -INT_MIN) {
		*integral = -(int) cardinal;
	    } else {
		*integral = INT_MIN;
	    }
#endif				/* INT_MAX + INT_MIN < 0 */
	}
    }

    return status;
}
