/*
 * ffloat.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdio.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
extern int x1f4_xprint_cfloat(char *, unsigned, double, unsigned *);
extern int x1f4_xprint_float(char *, unsigned, double);
#endif				/* !LIBx1f4i0 */

int
x1f4_fprint_pwfloat(FILE *output, int alignment, unsigned width,
		    unsigned Precision, unsigned precision, double value)
{
    char buffer[312];
    int status;
    unsigned diff = 0, digits, length;

    length = x1f4_xprint_cfloat(buffer, precision, value, &digits);

    if (digits < Precision) {
	diff = Precision - digits;
	if (!digits) {
	    diff++;
	}
	if (width < length) {
	    width = 0;
	} else {
	    if (alignment) {
		alignment = 0;
		if (length + diff < width) {
		    diff += width - length;
		}
		width = 0;
	    } else {
		if (diff < width) {
		    width -= diff;
		} else {
		    width = 0;
		}
	    }
	}
    }
    {
	int field;

	field = width;
	if (alignment) {
	    field = -field;
	}
	status = fprintf(output, "%*s", field, buffer);
    }
    if (!(status < 0)) {
	if (diff) {
	    unsigned i;

	    for (i = diff; i; i--) {
		int Status;

		Status = fputc(' ', output);
		if (Status == EOF) {
		    status = -1;
		    break;
		}
	    }
	    if (!(status < 0)) {
		status += diff;
	    }
	}
    }

    return status;
}


int
x1f4_fprint_wfloat(FILE *output, int alignment, unsigned width,
		   unsigned precision, double value)
{
    char buffer[312];
    int status;

    x1f4_xprint_float(buffer, precision, value);

    status = fprintf(output, alignment ? "%-*s" : "%*s", width, buffer);

    return status;
}
