/*
 * ckeytree.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ctkey-types.h>

int
x1f4_find_ctkey(const char *string, const struct keytree_type *root,
		unsigned *key)
{
    char *s;
    int status = 1;
    const struct keytree_type *list;

    list = root;

    s = root->string;

    while (1) {
	int c;

	c = *string;
	string++;
	if (!c) {
	    if (!list->children) {
		*key = list->data.code;
		status = 0;
	    } else {
		if (!*s) {
		    for (list = list->children; list->string; list++) {
			if (!*list->string) {
			    *key = list->data.code;
			    status = 0;
			    break;
			}
		    }
		}
	    }

	    break;
	} else {
	    if (*s) {
		if (c == *s) {
		    s++;
		} else {
		    break;
		}
	    } else {
		if (!list->children) {
		    break;
		} else {
		    for (list = list->children; list->string; list++) {
			if (c == *list->string) {
			    break;
			}
		    }

		    s = list->string;
		    if (!s) {
			break;
		    } else {
			s++;
		    }
		}
	    }
	}
    }

    return status;
}
