/*
 * zero-prefix.v.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char prefix[] = "0000000000000000";

int
x1f4_vprint_0prefix(void *data, int (*this) (void *, const char *, unsigned),
		    unsigned f)
{
    int status = 0;

    while (f) {
	unsigned e;

	e = f < 16 ? f : 16;
	status = this(data, prefix, e);
	if (status) {
	    break;
	} else {
	    f -= e;
	}
    }

    return status;
}
