/*
 * xls.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_XLS_H__
#define __LIBx1f4_XLS_H__

#include <config.h>

#if !defined BITS_LONG
# define BITS_LONG			unsigned long
#endif				/* !BITS_LONG */

#if !defined BITS_MODE
# define BITS_MODE			unsigned
#endif				/* !BITS_MODE */

#define l2_1_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c, l4f1_e, l4f1_i, l4f1_n;			      \
									      \
	l4f1_i = (l4f1_mode);						      \
									      \
	l4f1_c = -(l4f1_i >> 16);					      \
	l4f1_e = (l4f1_c >> 16) & 16;					      \
	l4f1_n = 16 - l4f1_e;						      \
	l4f1_i >>= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x100;					      \
	l4f1_e = (l4f1_c >> 16) & 8;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x1000;					      \
	l4f1_e = (l4f1_c >> 16) & 4;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x4000;					      \
	l4f1_e = (l4f1_c >> 16) & 2;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i >> 14;						      \
	l4f1_e = l4f1_c & ~(l4f1_c >> 1);				      \
									      \
	(l4f1_xxls) = l4f1_n + 2 - l4f1_e;				      \
    }

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_LONG l4f1_c, l4f1_e, l4f1_i, l4f1_n;			      \
									      \
	l4f1_i = (l4f1_mode);						      \
									      \
	l4f1_c = -(l4f1_i >> 32);					      \
	l4f1_e = (l4f1_c >> 32) & 32;					      \
	l4f1_n = 32 - l4f1_e;						      \
	l4f1_i >>= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x10000;					      \
	l4f1_e = (l4f1_c >> 32) & 16;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x1000000;					      \
	l4f1_e = (l4f1_c >> 32) & 8;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x10000000;					      \
	l4f1_e = (l4f1_c >> 32) & 4;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x40000000;					      \
	l4f1_e = (l4f1_c >> 32) & 2;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i >> 30;						      \
	l4f1_e = l4f1_c & ~(l4f1_c >> 1);				      \
									      \
	(l4f1_xxls) = l4f1_n + 2 - l4f1_e;				      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_xls(l4f1_xxls, l4f1_mode) \
    l2_1_xls((l4f1_xxls), (l4f1_mode))
#else
# define l2_q_xls(l4f1_xxls, l4f1_mode) \
    l2_2_xls((l4f1_xxls), (l4f1_mode))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_xls(l4f1_xxls, l4f1_mode) \
    l2_1_xls((l4f1_xxls), (l4f1_mode))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#endif				/* __LIBx1f4_XLS_H__ */
