/*
 * xfs.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_XFS_H__
#define __LIBx1f4_XFS_H__

#include <config.h>

#if !defined BITS_LONG
# define BITS_LONG			unsigned long
#endif				/* !BITS_LONG */

#if !defined BITS_MODE
# define BITS_MODE			unsigned
#endif				/* !BITS_MODE */

#define l2_1_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = ~l4f1_c & (l4f1_c - 1);				      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x55555555);			      \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 2) & 0x33333333);	      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f;			      \
	l4f1_c = l4f1_c + (l4f1_c << 8);				      \
	l4f1_c = l4f1_c + (l4f1_c << 16);				      \
									      \
	(l4f1_xxfs) = l4f1_c >> 24;					      \
    }

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_LONG l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = ~l4f1_c & (l4f1_c - 1);				      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x5555555555555555ul);	      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 2) & 0x3333333333333333ul);			      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f0f0f0f0ful;	      \
	l4f1_c = l4f1_c + (l4f1_c << 8);				      \
	l4f1_c = l4f1_c + (l4f1_c << 16);				      \
	l4f1_c = l4f1_c + (l4f1_c << 32);				      \
									      \
	(l4f1_xxfs) = l4f1_c >> 56;					      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_xfs(l4f1_xxfs, l4f1_mode) \
    l2_1_xfs((l4f1_xxfs), (l4f1_mode))
#else
# define l2_q_xfs(l4f1_xxfs, l4f1_mode) \
    l2_2_xfs((l4f1_xxfs), (l4f1_mode))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_xfs(l4f1_xxfs, l4f1_mode) \
    l2_1_xfs((l4f1_xxfs), (l4f1_mode))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#endif				/* __LIBx1f4_XFS_H__ */
