/*
 * track.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-m.0.h>
#include <track.h>

static int line_port(void *);
static int post_port(void *);
static int push_port(void *, const char *, unsigned);

static int
line_port(void *context)
{
    int status;
    struct x1f4_track_type *track_data;

    track_data = *(struct x1f4_track_type **) context;
    if (track_data->line) {
	status = track_data->line(track_data->data);
    } else {
	status = 1;
    }

    return status;
}


static int
post_port(void *context)
{
    int status;
    struct x1f4_track_type *track_data;

    track_data = *(struct x1f4_track_type **) context;
    if (track_data->post) {
	status = track_data->post(track_data->data);
    } else {
	status = 0;
    }

    return status;
}


static int
push_port(void *context, const char *data, unsigned size)
{
    int status;
    struct x1f4_track_type *track_data;

    track_data = *(struct x1f4_track_type **) context;
    if (track_data->push) {
	status = track_data->push(track_data->data, data, size);
    } else {
	status = 0;
    }

    return status;
}


void
x1f4_rule_eproxy(struct x1f4_track_type *track_data)
{
    track_data->line = line_port;
    track_data->post = post_port;
    track_data->push = push_port;
}
