/*
 * tcvset.h
 * Copyright (C) 2008-2009, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_TCVSET_H__
#define __LIBx1f4_TCVSET_H__

#include <tcvs-names.h>

/*
 * error definitions
 */
#define X1f4_TCVSET_FREE_ERROR		-3
#define X1f4_TCVSET_LINK_ERROR		-4
#define X1f4_TCVSET_MODE_ERROR		-5

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

typedef struct x1f4_tccase_type {
    int (*high) (void **, const void **, struct x1f4_trans_type *),
	(*lime) (void *, void *, int (*) (void *, void *)),
	(*miss) (void **, const void **, const void *,
		 struct x1f4_trans_type *),
	(*mode) (void **, const void *, const void *),
	(*push) (void **, const void **, const void *,
		 struct x1f4_trans_type *), (*size) (void *, unsigned *);
} x1f4_tccase_type;

extern int x1f4_fini_tcvset(void **, const void **, struct x1f4_trans_type *);
extern int x1f4_init_tcvset(void **, const void **);

#endif				/* __LIBx1f4_TCVSET_H__ */
