/*
 * tcvs.t.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <tcline.h>
#include <tcvs-defs.h>
#include <tcvs-inter.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

#define REVERT_SIZE			4

#define __NEAR_MISS__			1
#define __PASS_MISS__			2

#define __HERE_MISS__			__NEAR_MISS__

#define integral_d(___p)		((integral_q) (___p))

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

typedef struct post_type {
    int (*call) (void *, void *);
    void *back;
} post_type;

extern const struct tccase_type _libx1f4l2_tcvs_i;

static int deck_miss(void *, void *);
static int high_vset(void **, const void **, struct trans_type *);
static int lime_vset(void *, void *, int (*) (void *, void *));
static int near_mode(void *, void *);
static int miss_vset(void **, const void **, const void *,
		     struct trans_type *);
static int mode_vset(void **, const void *, const void *);
static int post_call(void *, void *);
static int push_vset(void **, const void **, const void *,
		     struct trans_type *);
static int size_vset(void *, unsigned *);

const struct tccase_type _libx1f4l2_tcvs_t = {
/* *INDENT-OFF* */
    high_vset,
    lime_vset,
    miss_vset,
    mode_vset,
    push_vset,
    size_vset
/* *INDENT-ON* */
};

static int
deck_miss(void *deck, void *miss)
{
    int true;

    miss = *(void **) miss;

    if (integral_d(deck) < integral_d(miss)) {
	true = -1;
    } else {
	if (integral_d(miss) < integral_d(deck)) {
	    true = 1;
	} else {
	    true = 0;
	}
    }

    return true;
}


static int
high_vset(void **tcvset, const void **tccase, struct trans_type *trans_data)
{
    int status;
    struct tcline_type *tcline_data;

    tcline_data = *tcvset;

    status = x1f4_flat_tcline(tcline_data + 1);
    if (status) {
    } else {
	status = trans_data->free(trans_data->data, tcline_data);
	if (status) {
	    status = FREE_ERROR;
	} else {
	    *tcvset = NULL;

	    *tccase = &_libx1f4l2_tcvs_i;
	}
    }

    return status;
}


static int
lime_vset(void *vset, void *back, int (*call) (void *, void *))
{
    struct post_type post;

    post.back = back;
    post.call = call;

    return x1f4_lime_tcline
	(((struct tcline_type *) vset) + 1, &post, post_call);
}


static int
near_mode(void *near, void *mode)
{
    int delete;
    struct tcnode_type *tcnode_data;
    unsigned ever;

    tcnode_data = mode;

    ever = tcnode_data->ever;
    ever--;
    if (ever) {
	tcnode_data->ever = ever;

	delete = 1;
    } else {
	delete = 0;
    }

    return delete;
}


static int
miss_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    int status;
    struct tcline_type *tcline_data;
#if __HERE_MISS__ == __PASS_MISS__
    void *data;
#endif				/* __HERE_MISS__ == __PASS_MISS__ */

    tcline_data = *tcvset;

#if __HERE_MISS__ == __NEAR_MISS__
    status = x1f4_shut_tcline
	(tcline_data + 1, (void *) clip, deck_miss,
	 offsetof(struct tcnode_type, data), NULL, near_mode);
    if (status) {
	if (status == X1f4_TCLINE_MISS_CLASS) {
	    status = 0;
	}
    } else {
	unsigned size;

	size = tcline_data->data.size;
	size--;
	if (size == REVERT_SIZE) {
	    status = _libx1f4l2_flat_tcvset
		(tcvset, tccase, tcline_data, trans_data);
	} else {
	    tcline_data->data.size = size;
	}
    }
#else
    status = x1f4_find_tcline
	(tcline_data + 1, (void *) clip, offsetof(struct tcnode_type, data),
	 deck_miss, &data);
    if (status) {
	do {
	    struct tcnode_type *tcnode_data;
	    unsigned ever, size;

	    tcnode_data = data;

	    ever = tcnode_data->ever;
	    ever--;
	    if (ever) {
		tcnode_data->ever = ever;

		status = 0;
	    } else {
		status = x1f4_pass_tcline
		    (tcline_data + 1, (void *) clip, deck_miss,
		     offsetof(struct tcnode_type, data));
		if (status) {
		    break;
		}
	    }

	    size = tcline_data->data.size;
	    size--;
	    if (size == REVERT_SIZE) {
		status = _libx1f4l2_flat_tcvset
		    (tcvset, tccase, tcline_data, trans_data);
	    } else {
		tcline_data->data.size = size;
	    }
	} while (0);
    }
#endif				/* __HERE_MISS__ == __NEAR_MISS__ */

    return status;
}


static int
mode_vset(void **tcvset, const void *miss, const void *push)
{
    int status;
    struct tcline_type *tcline_data;

    tcline_data = *tcvset;

    status = x1f4_shut_tcline
	(tcline_data + 1, (void *) miss, deck_miss,
	 offsetof(struct tcnode_type, data), NULL, near_mode);
    if (status) {
	if (status == X1f4_TCLINE_MISS_CLASS) {
	    status = 0;
	}
    } else {
	void *data;

	tcline_data->data.size--;

	status = x1f4_post_tcline
	    (tcline_data + 1, (void *) push, deck_miss,
	     offsetof(struct tcnode_type, data),
	     sizeof(struct tcnode_type), &data);
	if (status) {
	    if (status == X1f4_TCLINE_EVER_MATCH) {
		((struct tcnode_type *) data)->ever++;

		tcline_data->data.size++;

		status = 0;
	    }
	} else {
	    struct tcnode_type *tcnode_data;

	    tcnode_data = data;

	    tcnode_data->ever = 1;

	    tcnode_data->data = push;

	    tcline_data->data.size++;
	}
    }

    return status;
}


static int
post_call(void *post, void *call)
{
    return ((struct post_type *) post)->call
	(((struct post_type *) post)->back,
	 (void *) ((struct tcnode_type *) call)->data);
}


static int
push_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    int status;
    struct tcline_type *tcline_data;
    void *data;

    tcline_data = *tcvset;

    status = x1f4_post_tcline
	(tcline_data + 1, (void *) clip, deck_miss,
	 offsetof(struct tcnode_type, data), sizeof(struct tcnode_type),
	 &data);
    if (status) {
	if (status == X1f4_TCLINE_EVER_MATCH) {
	    ((struct tcnode_type *) data)->ever++;

	    tcline_data->data.size++;

	    status = 0;
	}
    } else {
	struct tcnode_type *tcnode_data;

	tcnode_data = data;

	tcnode_data->ever = 1;

	tcnode_data->data = clip;

	tcline_data->data.size++;
    }

    return status;
}


static int
size_vset(void *vset, unsigned *size)
{
    *size = ((struct tcline_type *) vset)->data.size;

    return 0;
}
