/*
 * tcvs.o.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <tcvs-defs.h>
#include <tcvs-inter.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

#define ALWAYS_ZERO			0

#define REVERT_SIZE			1

#if REVERT_SIZE
# define REVERT_NULL			0
#else
# define REVERT_NULL			1
#endif				/* REVERT_SIE */

#define class

#define integral_d(___p)		((integral_q) (___p))

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

extern const struct tccase_type _libx1f4l2_tcvs_i;

static int high_vset(void **, const void **, struct trans_type *);
static int lime_vset(void *, void *, int (*) (void *, void *));
static int miss_vset(void **, const void **, const void *,
		     struct trans_type *);
static int mode_vset(void **, const void *, const void *);
static int push_vset(void **, const void **, const void *,
		     struct trans_type *);
static int size_vset(void *, unsigned *);

const struct tccase_type _libx1f4l2_tcvs_o = {
/* *INDENT-OFF* */
    high_vset,
    lime_vset,
    miss_vset,
    mode_vset,
    push_vset,
    size_vset
/* *INDENT-ON* */
};

static int
high_vset(void **tcvset, const void **tccase, struct trans_type *trans_data)
{
    int status;

    status = trans_data->free(trans_data->data, *tcvset);
    if (status) {
	status = FREE_ERROR;
    } else {
	*tcvset = NULL;

	*tccase = &_libx1f4l2_tcvs_i;
    }

    return status;
}


static int
lime_vset(void *vset, void *back, int (*call) (void *, void *))
{
    int status;
    const void *clip, **slip;

    slip = vset;

    clip = *slip;
#if ALWAYS_ZERO
    if (clip) {
#endif				/* ALWAYS_ZERO */
	status = call(back, (void *) clip);
	if (status) {
	} else {
	    do {
		const void *ever;

		slip++;
		ever = *slip;
#if REVERT_NULL
		if (ever) {
#endif				/* REVERT_NULL */
		    if (ever == clip) {
		    } else {
			status = call(back, (void *) ever);
			if (status) {
			    break;
			}
		    }
#if REVERT_NULL
		} else {
		    break;
		}
#endif				/* REVERT_NULL */

		slip++;
		clip = *slip;
		if (clip) {
		    if (clip == ever) {
		    } else {
			status = call(back, (void *) clip);
			if (status) {
			    break;
			}
		    }
		} else {
		    break;
		}

		slip++;
		ever = *slip;
		if (ever) {
		    if (ever == clip) {
		    } else {
			status = call(back, (void *) ever);
			if (status) {
			    class;
			}
		    }
		} else {
		    class;
		}
	    } while (0);
	}
#if ALWAYS_ZERO
    } else {
	status = 0;
    }
#endif				/* ALWAYS_ZERO */

    return status;
}


static int
miss_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    int status;
    const void **vset;

    vset = *tcvset;

    if (clip == vset[0]) {
#if REVERT_NULL
	clip = vset[1];
	if (clip) {
#endif				/* REVERT_NULL */
#if REVERT_SIZE
	    const void *deck;
#endif				/* REVERT_SIZE */

#if REVERT_SIZE
	    deck = vset[2];
	    if (deck) {
#endif				/* REVERT_SIZE */
#if REVERT_NULL
		vset[0] = clip;
#else
		vset[0] = vset[1];
#endif				/* REVERT_NULL */
#if REVERT_SIZE
		vset[1] = deck;
#else
		vset[1] = vset[2];
#endif				/* REVERT_SIZE */
		vset[2] = vset[3];
		vset[3] = NULL;

		status = 0;
#if REVERT_SIZE
	    } else {
		clip = vset[1];

		status = trans_data->free(trans_data->data, *tcvset);
		if (status) {
		    status = FREE_ERROR;
		} else {
		    *tcvset = (void *) clip;

		    *tccase = &_libx1f4l2_tcvs_i;
		}
	    }
#endif				/* REVERT_SIZE */
#if REVERT_NULL
	} else {
	    status = trans_data->free(trans_data->data, *tcvset);
	    if (status) {
		status = FREE_ERROR;
	    } else {
		*tcvset = NULL;

		*tccase = &_libx1f4l2_tcvs_i;
	    }
	}
#endif				/* REVERT_NULL */
    } else {
	if (clip == vset[1]) {
#if REVERT_SIZE
	    clip = vset[2];
	    if (clip) {
		status = 0;

		vset[1] = clip;
#else
		vset[1] = vset[2];
#endif				/* REVERT_SIZE */
		vset[2] = vset[3];
		vset[3] = NULL;

		status = 0;
#if REVERT_SIZE
	    } else {
		const void *mind;

		mind = vset[0];

		status = trans_data->free(trans_data->data, *tcvset);
		if (status) {
		    status = FREE_ERROR;
		} else {
		    *tcvset = (void *) mind;

		    *tccase = &_libx1f4l2_tcvs_i;
		}
	    }
#endif				/* REVERT_SIZE */
	} else {
	    status = 0;

	    if (clip == vset[2]) {
		vset[2] = vset[3];
		vset[3] = NULL;
	    } else {
		if (clip == vset[3]) {
		    vset[3] = NULL;
		} else {
		}
	    }
	}
    }

    return status;
}


static int
mode_vset(void **tcvset, const void *miss, const void *push)
{
    const void **slip;

    slip = *tcvset;

    if (miss == slip[0]) {
	if (integral_d(miss) < integral_d(push)) {
	    if (slip[1]) {
		if (integral_d(slip[1]) < integral_d(push)) {
		    slip[0] = slip[1];
		    if (slip[2]) {
			if (integral_d(slip[2]) < integral_d(push)) {
			    slip[1] = slip[2];
			    if (slip[3]) {
				if (integral_d(slip[3]) < integral_d(push)) {
				    slip[2] = slip[3];
				    slip[3] = push;
				} else {
				    slip[2] = push;
				}
			    } else {
				slip[2] = push;
			    }
			} else {
			    slip[1] = push;
			}
		    } else {
			slip[1] = push;
		    }
		} else {
		    slip[0] = push;
		}
	    } else {
		slip[0] = push;
	    }
	} else {
	    slip[0] = push;
	}
    } else {
	if (miss == slip[1]) {
	    if (integral_d(miss) < integral_d(push)) {
		if (slip[2]) {
		    if (integral_d(slip[2]) < integral_d(push)) {
			slip[1] = slip[2];
			if (slip[3]) {
			    if (integral_d(slip[3]) < integral_d(push)) {
				slip[2] = slip[3];
				slip[3] = push;
			    } else {
				slip[2] = push;
			    }
			} else {
			    slip[2] = push;
			}
		    } else {
			slip[1] = push;
		    }
		} else {
		    slip[1] = push;
		}
	    } else {
		if (integral_d(push) < integral_d(slip[0])) {
		    slip[1] = slip[0];
		    slip[0] = push;
		} else {
		    slip[1] = push;
		}
	    }
	} else {
	    if (miss == slip[2]) {
		if (integral_d(miss) < integral_d(push)) {
		    if (slip[3]) {
			if (integral_d(slip[3]) < integral_d(push)) {
			    slip[2] = slip[3];
			    slip[3] = push;
			} else {
			    slip[2] = push;
			}
		    } else {
			slip[2] = push;
		    }
		} else {
		    if (integral_d(push) < integral_d(slip[1])) {
			slip[2] = slip[1];
			if (integral_d(push) < integral_d(slip[0])) {
			    slip[1] = slip[0];
			    slip[0] = push;
			} else {
			    slip[1] = push;
			}
		    } else {
			slip[2] = push;
		    }
		}
	    } else {
		if (miss == slip[3]) {
		    if (integral_d(miss) < integral_d(push)) {
			slip[3] = push;
		    } else {
			if (integral_d(push) < integral_d(slip[2])) {
			    slip[3] = slip[2];
			    if (integral_d(push) < integral_d(slip[1])) {
				slip[2] = slip[1];
				if (integral_d(push) < integral_d(slip[0])) {
				    slip[1] = slip[0];
				    slip[0] = push;
				} else {
				    slip[1] = push;
				}
			    } else {
				slip[2] = push;
			    }
			} else {
			    slip[3] = push;
			}
		    }
		} else {
		}
	    }
	}
    }

    return 0;
}


static int
push_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    int status;
    const void **vset;

    vset = *tcvset;

#if ALWAYS_ZERO
    if (vset[0]) {
#endif				/* ALWAYS_ZERO */
#if REVERT_NULL
	if (vset[1]) {
#endif				/* REVERT_NULL */
	    if (vset[2]) {
		if (vset[3]) {
		    status = _libx1f4l2_fast_tcvset
			(tcvset, tccase, clip, vset, trans_data);
		} else {
		    status = 0;

		    if (integral_d(clip) < integral_d(vset[0])) {
			vset[3] = vset[2];
			vset[2] = vset[1];
			vset[1] = vset[0];
			vset[0] = clip;
		    } else {
			if (integral_d(clip) < integral_d(vset[1])) {
			    vset[3] = vset[2];
			    vset[2] = vset[1];
			    vset[1] = clip;
			} else {
			    if (integral_d(clip) < integral_d(vset[2])) {
				vset[3] = vset[2];
				vset[2] = clip;
			    } else {
				vset[3] = clip;
			    }
			}
		    }
		}
	    } else {
		status = 0;

		if (integral_d(clip) < integral_d(vset[0])) {
		    vset[2] = vset[1];
		    vset[1] = vset[0];
		    vset[0] = clip;
		} else {
		    if (integral_d(clip) < integral_d(vset[1])) {
			vset[2] = vset[1];
			vset[1] = clip;
		    } else {
			vset[2] = clip;
		    }
		}
	    }
#if REVERT_NULL
	} else {
	    status = 0;

	    if (integral_d(clip) < integral_d(vset[0])) {
		vset[1] = vset[0];
		vset[0] = clip;
	    } else {
		vset[1] = clip;
	    }
	}
#endif				/* REVERT_NULL */
#if ALWAYS_ZERO
    } else {
	status = 0;

	vset[0] = clip;
    }
#endif				/* ALWAYS_ZERO */

    return status;
}


static int
size_vset(void *vset, unsigned *size)
{
    const void **slip;

    slip = vset;

    if (slip[3]) {
	*size = 4;
    } else {
	if (slip[2]) {
	    *size = 3;
	} else {
#if REVERT_NULL
	    if (slip[1]) {
#endif				/* REVERT_NULL */
		*size = 2;
#if REVERT_NULL
	    } else {
#endif				/* REVERT_NULL */
#if ALWAYS_ZERO
		if (slip[0]) {
#endif				/* ALWAYS_ZERO */
#if REVERT_NULL
		    *size = 1;
#endif				/* REVERT_NULL */
#if ALWAYS_ZERO
		} else {
		}
#endif				/* ALWAYS_ZERO */
#if REVERT_NULL
	    }
#endif				/* REVERT_NULL */
	}
    }

    return 0;
}
