/*
 * tcvs-types.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_tcvs_types_H__
#define __LIBx1f4_tcvs_types_H__

#include <trans.h>

typedef struct tccase_type {
    int (*high) (void **, const void **, struct trans_type *),
	(*lime) (void *, void *, int (*) (void *, void *)),
	(*miss) (void **, const void **, const void *, struct trans_type *),
	(*mode) (void **, const void *, const void *),
	(*push) (void **, const void **, const void *, struct trans_type *),
	(*size) (void *, unsigned *);
} tccase_type;

typedef struct tcline_type {
    union {
	unsigned size;
	void *data;
    } data;
} tcline_type;

typedef struct tcnode_type {
    unsigned ever;
    const void *data;
} tcnode_type;

#endif				/* __LIBx1f4_tcvs_types_H__ */
