/*
 * tcqp.o.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-config.h>

#include <stddef.h>

#include <tcqp-defs.h>
#include <tcqp-inter.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define __SLICE_UPLINK__		1

#define ________UPLINK__		0

#if ____CLASS_DELETE__ == __SLICE_DELETE__
# define __CLASS_UPLINK__		__SLICE_UPLINK__
#else
# define __CLASS_UPLINK__		________UPLINK__
#endif				/* ____CLASS_DELETE__ == __SLICE_DELETE__ */

#define ____CLASS_UPLINK__		__CLASS_UPLINK__

#if ____CLASS_DELETE__ == __SLICE_DELETE__
# undef __CLASS_DELETE__
# define __CLASS_DELETE__		__TRACE_DELETE__
#endif				/* ____CLASS_DELETE__ == __SLICE_DELETE__ */

/*
 * __SCOPE_UPLINK__ method is buggy, for if processing stops the tree is left
 * messed up.  plus, MISS_CLASS is not set, and the to be deleted node is
 * supposed existing.
 */
#define __SCOPE_UPLINK__		1
#define __SHORT_UPLINK__		2

#define __________LINK__		0

#if ____CLASS_DELETE__ == __TRACE_DELETE__
# define __BREAK_UPLINK__		__SHORT_UPLINK__
#else
# define __BREAK_UPLINK__		__________LINK__
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#define ____BREAK_UPLINK__		__BREAK_UPLINK__

#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
# define SET_T(fpnode_data, tilt) \
    (fpnode_data)->fqnode.fbnode.bits = (tilt)
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */

#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
# define GET_T(fpnode_data) \
    (fpnode_data)->fqnode.fbnode.bits
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
# define shift_break(fsnode_data, fxnode_data, fznode_data) \
    {									      \
	unsigned tilt;							      \
									      \
	tilt = GET_T((fxnode_data));					      \
	(fznode_data) = (fxnode_data)->fpnode_data[tilt];		      \
	(fxnode_data)->fpnode_data[tilt] = (fsnode_data);		      \
    }
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */

#define tcline(tcline)			((struct tcline_type *) (tcline))

int
_libx1f4l2_nand_tcline(void *tcline, void *text, int (*land) (void *, void *),
		       unsigned offset, void *back,
		       int (*call) (void *, void *))
{
    int status = 0;
#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
    struct fpnode_type *ffnode_data;
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */
#if ____CLASS_DELETE__ == __TRACE_DELETE__
    struct fpnode_type *fhnode_data;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
#if ____CLASS_DELETE__ == __STACK_DELETE__
    struct fpnode_type **fpmiss;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
    struct fpnode_type fpnode, *fpnode_data;
#if ____CLASS_DELETE__ == __STACK_DELETE__
    unsigned miss = 1, seek, size;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
#if ____CLASS_DELETE__ == __TRACE_DELETE__
    unsigned slip = 0;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
#if ____CLASS_DELETE__ == __STACK_DELETE__
    unsigned char *data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
    data = tcline(tcline)->link_c.data;
    size = tcline(tcline)->link_c.size;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
    seek = tcline(tcline)->link_e.seek;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
    fpmiss = tcline(tcline)->link_e.fpmiss;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
    fpmiss[0] = &tcline(tcline)->link_a.fpline.fplink;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __TRACE_DELETE__
    fhnode_data = &tcline(tcline)->link_a.fpline.fplink;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
    ffnode_data = fhnode_data;
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */

    fpnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];

#if ____CLASS_DELETE__ == __STACK_DELETE__
    data[0] = 0;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

    while (1) {
	int fast;
#if ____CLASS_DELETE__ == __STACK_DELETE__
	unsigned tilt;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

	fast = land(text, (char *) fpnode_data + offset);

	if (fast) {
	    if (fast < 0) {
#if ____CLASS_DELETE__ == __STACK_DELETE__
		tilt = 0;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		slip = 0;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
	    } else {
#if ____CLASS_DELETE__ == __STACK_DELETE__
		tilt = 1;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		slip = 1;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
	    }
	} else {
	    if (1) {
		break;
	    }
	}

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
	if (fpnode_data->fqnode.tilt) {
	} else {
	    ffnode_data = fhnode_data;
	}
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	if (fpnode_data->fqnode.tilt) {
	} else {
	    miss--;

	    data[0] = data[miss];

	    fpmiss[0] = fpmiss[miss];

	    miss = 1;
	}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	if (miss == size) {
	    status = _libx1f4l2_half_tcline(tcline, &data, &size);
	    if (status) {
		/*
		 * TODO
		 *
		 * list is in an inconsistent state - only operation that
		 * should work fine is destroying it.
		 */
		break;
	    }
	}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	data[miss] = tilt;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	if (miss == seek) {
	    status = _libx1f4l2_blue_tcline(tcline, &fpmiss, &seek);
	    if (status) {
		/*
		 * TODO
		 *
		 * list is in an inconsistent state - only operation that
		 * should work fine is destroying it.
		 */
		break;
	    }
	}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	fpmiss[miss] = fpnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	miss++;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
	SET_T(fpnode_data, slip);
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
	fpnode_data = fpnode_data->fpnode_data[tilt];
	if (fpnode_data) {
	} else {
	    status = MISS_CLASS;
	    if (1) {
		break;
	    }
	}
#elif __BREAK_UPLINK__ == __SHORT_UPLINK__
	fhnode_data = fpnode_data;
	fpnode_data = fpnode_data->fpnode_data[slip];
	if (fpnode_data) {
	} else {
	    status = MISS_CLASS;
	    if (1) {
		break;
	    }
	}
#elif __CLASS_DELETE__ == __TRACE_DELETE__
	if (1) {
	    struct fpnode_type *fsnode_data;

	    fsnode_data = fpnode_data->fpnode_data[slip];
	    fpnode_data->fpnode_data[slip] = fhnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
#elif __CLASS_UPLINK__ == __SLICE_UPLINK__
	    SET_T(fpnode_data, slip);
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */
#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
#elif __CLASS_DELETE__ == __TRACE_DELETE__
	    fhnode_data = fpnode_data;

	    fpnode_data = fsnode_data;
	}
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */
    }

    if (status) {
    } else {
	fpnode = *fpnode_data;

	status = call(back, fpnode_data);
    }

    if (status) {
#if 0
	if (status == MISS_CLASS) {
	    status = 0;
	}
#endif				/* 0 */
    } else {
#if ____CLASS_DELETE__ == __TRACE_DELETE__
	struct fpnode_type *fvnode_data;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
	if (ffnode_data == &tcline(tcline)->link_a.fpline.fplink) {
	    fvnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
	    SET_T(ffnode_data, 0);
	} else {
	    fvnode_data = ffnode_data->fpnode_data[GET_T(ffnode_data)];
	}
	fhnode_data = ffnode_data;
	if (fvnode_data == fpnode_data) {
	} else {
	    while (1) {
		struct fpnode_type *fqnode_data;

		shift_break(fhnode_data, fvnode_data, fqnode_data);
		if (fqnode_data == fpnode_data) {
		    if (1) {
			fhnode_data = fvnode_data;
		    }

		    break;
		} else {
		    shift_break(fvnode_data, fqnode_data, fhnode_data);
		    if (fhnode_data == fpnode_data) {
			if (1) {
			    fhnode_data = fqnode_data;
			}

			break;
		    } else {
			shift_break(fqnode_data, fhnode_data, fvnode_data);
			if (fvnode_data == fpnode_data) {
			    if (0) {
				fhnode_data = fhnode_data;
			    }

			    break;
			}
		    }
		}
	    }
	}
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */

	fpnode_data = &fpnode;

	do {
	    struct fpnode_type *fqnode_data;

	    fqnode_data = fpnode_data->fpnode_data[1];
	    if (!fqnode_data) {
#if ____CLASS_DELETE__ == __STACK_DELETE__
		fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
		    fpnode_data->fpnode_data[0];
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		fvnode_data = fpnode_data->fpnode_data[0];
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
	    } else {
		if (!fqnode_data->fpnode_data[0]) {
		    struct fpnode_type *fjnode_data;

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    if (miss == size) {
			status = _libx1f4l2_half_tcline(tcline, &data, &size);
			if (status) {
			    /*
			     * TODO
			     *
			     * list is in an inconsistent state - only
			     * operation that should work fine is destroying
			     * it.
			     */
			    break;
			}
		    }
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    if (miss == seek) {
			status = _libx1f4l2_blue_tcline
			    (tcline, &fpmiss, &seek);
			if (status) {
			    /*
			     * TODO
			     *
			     * list is in an inconsistent state - only
			     * operation that should work fine is destroying
			     * it.
			     */
			    break;
			}
		    }
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

		    fjnode_data = fpnode_data->fpnode_data[0];
		    fqnode_data->fpnode_data[0] = fjnode_data;
#if ____CLASS_DELETE__ == __TRACE_DELETE__
		    fvnode_data = fqnode_data->fpnode_data[1];
		    fqnode_data->fpnode_data[1] = fhnode_data;
		    fhnode_data = fqnode_data;
		    slip = 1;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
		    fqnode_data->fqnode.tilt = fpnode_data->fqnode.tilt;
#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
			fqnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    data[miss] = 1;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fpmiss[miss] = fqnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    miss++;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
		    if (0) {
			SET_T(fqnode_data, 1);
		    }
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */
		} else {
		    struct fpnode_type *fjnode_data, *flnode_data,
			*fsnode_data;
#if ____CLASS_DELETE__ == __STACK_DELETE__
		    unsigned fast;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fast = miss;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    if (miss == size) {
			status = _libx1f4l2_half_tcline(tcline, &data, &size);
			if (status) {
			    /*
			     * TODO
			     *
			     * list is in an inconsistent state - only
			     * operation that should work fine is destroying
			     * it.
			     */
			    break;
			}
		    }
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    if (miss == seek) {
			status = _libx1f4l2_blue_tcline
			    (tcline, &fpmiss, &seek);
			if (status) {
			    /*
			     * TODO
			     *
			     * list is in an inconsistent state - only
			     * operation that should work fine is destroying
			     * it.
			     */
			    break;
			}
		    }
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    miss++;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

		    fjnode_data = fqnode_data->fpnode_data[0];
		    for (;;) {
#if ____CLASS_DELETE__ == __STACK_DELETE__
			if (miss == size) {
			    status = _libx1f4l2_half_tcline
				(tcline, &data, &size);
			    if (status) {
				/*
				 * TODO
				 *
				 * list is in an inconsistent state - only
				 * operation that should work fine is
				 * destroying it.
				 */
				break;
			    }
			}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
			if (miss == seek) {
			    status = _libx1f4l2_blue_tcline
				(tcline, &fpmiss, &seek);
			    if (status) {
				/*
				 * TODO
				 *
				 * list is in an inconsistent state - only
				 * operation that should work fine is
				 * destroying it.
				 */
				break;
			    }
			}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
			data[miss] = 0;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
			fpmiss[miss] = fqnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
			miss++;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

			fsnode_data = fjnode_data;
			fjnode_data = fsnode_data->fpnode_data[0];
			if (fjnode_data) {
#if ____CLASS_DELETE__ == __TRACE_DELETE__
			    fsnode_data->fpnode_data[0] = fqnode_data;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
			    SET_T(fsnode_data, 0);
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */
			    fqnode_data = fsnode_data;
			} else {
			    break;
			}
		    }

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    if (status) {
			break;
		    }
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

		    fjnode_data = fpnode_data->fpnode_data[0];
#if ____CLASS_DELETE__ == __STACK_DELETE__
		    flnode_data = fsnode_data->fpnode_data[1];
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		    fvnode_data = fsnode_data->fpnode_data[1];
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
		    fsnode_data->fpnode_data[0] = fjnode_data;
#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fqnode_data->fpnode_data[0] = flnode_data;
		    fsnode_data->fpnode_data[1] = fpnode_data->fpnode_data[1];
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		    fsnode_data->fpnode_data[1] = fhnode_data;
		    fhnode_data = fqnode_data;
		    flnode_data = fpnode_data->fpnode_data[1];
		    flnode_data->fpnode_data[0] = fsnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
		    fsnode_data->fqnode.tilt = fpnode_data->fqnode.tilt;

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fpmiss[fast - 1]->fpnode_data[data[fast - 1]] =
			fsnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    data[fast] = 1;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __TRACE_DELETE__
		    slip = 0;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		    fpmiss[fast] = fsnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
		    SET_T(flnode_data, 0);
		    SET_T(fsnode_data, 1);
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */
		}
	    }

	    while (1) {
#if ____CLASS_DELETE__ == __TRACE_DELETE__
		unsigned dana;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		miss--;
		if (miss) {
		} else {
		    break;
		}
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		fqnode_data = fpmiss[miss];
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____BREAK_UPLINK__ == __SHORT_UPLINK__
		if (fhnode_data == ffnode_data) {
		    fhnode_data->fpnode_data[slip & 4095] = fvnode_data;
#elif 0
		}
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		if (fhnode_data == &tcline(tcline)->link_a.fpline.fplink) {
		    fhnode_data->fpnode_data[0] = fvnode_data;
#endif				/* ____BREAK_UPLINK__ == __SHORT_UPLINK__ */
#if ____CLASS_DELETE__ == __TRACE_DELETE__

		    break;
		} else {
		    unsigned skip;

		    skip = slip & 4096;

		    slip = slip & 4095;

		    fqnode_data = fhnode_data;
		    fhnode_data = fqnode_data->fpnode_data[slip];
		    fqnode_data->fpnode_data[slip] = fvnode_data;
		    fvnode_data = fqnode_data;

		    dana = slip;

#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
#if ____CLASS_UPLINK__ == __SLICE_UPLINK__
		    slip = GET_T(fhnode_data);
#endif				/* ____CLASS_UPLINK__ == __SLICE_UPLINK__ */
#if ____CLASS_DELETE__ == __TRACE_DELETE__

		    slip = slip | skip;
		    if (slip & 4096) {
			continue;
		    }
		}
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */

#if ____CLASS_DELETE__ == __STACK_DELETE__
		if (!data[miss]) {
#elif 0
		}
#elif __CLASS_DELETE__ == __TRACE_DELETE__
		if (!dana) {
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
		    int tilt;

		    tilt = fqnode_data->fqnode.tilt;

		    tilt++;

		    fqnode_data->fqnode.tilt = tilt;

		    if (tilt == 1) {
#if ____CLASS_DELETE__ == __TRACE_DELETE__
			slip |= 4096;
#elif __CLASS_DELETE__ == __STACK_DELETE__
			break;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
		    } else {
			if (tilt == 2) {
			    struct fpnode_type *fxnode_data;

			    fxnode_data = fqnode_data->fpnode_data[1];
			    if (fxnode_data->fqnode.tilt == -1) {
				int slip;
				struct fpnode_type *fbnode_data, *fdnode_data,
				    *fwnode_data;

				fwnode_data = fxnode_data->fpnode_data[0];
				fbnode_data = fwnode_data->fpnode_data[1];
				fxnode_data->fpnode_data[0] = fbnode_data;
				fwnode_data->fpnode_data[1] = fxnode_data;
				fdnode_data = fwnode_data->fpnode_data[0];
				fqnode_data->fpnode_data[1] = fdnode_data;
				fwnode_data->fpnode_data[0] = fqnode_data;
				slip = fwnode_data->fqnode.tilt;
				fwnode_data->fqnode.tilt = 0;
				if (slip == 1) {
				    fxnode_data->fqnode.tilt = 0;
				    fqnode_data->fqnode.tilt = -1;
				} else {
				    if (!slip) {
					fxnode_data->fqnode.tilt = 0;
					fqnode_data->fqnode.tilt = 0;
				    } else {
					fxnode_data->fqnode.tilt = 1;
					fqnode_data->fqnode.tilt = 0;
				    }
				}
#if ____CLASS_DELETE__ == __STACK_DELETE__
				fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
				    fwnode_data;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
				fvnode_data = fwnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
			    } else {
				struct fpnode_type *fmnode_data;

				fmnode_data = fxnode_data->fpnode_data[0];
				fqnode_data->fpnode_data[1] = fmnode_data;
				fxnode_data->fpnode_data[0] = fqnode_data;
#if ____CLASS_DELETE__ == __STACK_DELETE__
				fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
				    fxnode_data;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
				fvnode_data = fxnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
				if (fxnode_data->fqnode.tilt) {
				    fqnode_data->fqnode.tilt = 0;
				    fxnode_data->fqnode.tilt = 0;
				} else {
				    fqnode_data->fqnode.tilt = 1;
				    fxnode_data->fqnode.tilt = -1;
#if ____CLASS_DELETE__ == __TRACE_DELETE__
				    slip |= 4096;
#elif __CLASS_DELETE__ == __STACK_DELETE__
				    break;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
				}
			    }
			}
		    }
		} else {
		    int tilt;

		    tilt = fqnode_data->fqnode.tilt;

		    tilt--;

		    fqnode_data->fqnode.tilt = tilt;

		    if (tilt == -1) {
#if ____CLASS_DELETE__ == __TRACE_DELETE__
			slip |= 4096;
#elif __CLASS_DELETE__ == __STACK_DELETE__
			break;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
		    } else {
			if (tilt == -2) {
			    struct fpnode_type *fxnode_data;

			    fxnode_data = fqnode_data->fpnode_data[0];
			    if (fxnode_data->fqnode.tilt == 1) {
				int slip;
				struct fpnode_type *fbnode_data, *fdnode_data,
				    *fwnode_data;

				fwnode_data = fxnode_data->fpnode_data[1];
				fbnode_data = fwnode_data->fpnode_data[0];
				fxnode_data->fpnode_data[1] = fbnode_data;
				fwnode_data->fpnode_data[0] = fxnode_data;
				fdnode_data = fwnode_data->fpnode_data[1];
				fqnode_data->fpnode_data[0] = fdnode_data;
				fwnode_data->fpnode_data[1] = fqnode_data;
				slip = fwnode_data->fqnode.tilt;
				fwnode_data->fqnode.tilt = 0;
				if (slip == -1) {
				    fxnode_data->fqnode.tilt = 0;
				    fqnode_data->fqnode.tilt = 1;
				} else {
				    if (!slip) {
					fxnode_data->fqnode.tilt = 0;
					fqnode_data->fqnode.tilt = 0;
				    } else {
					fxnode_data->fqnode.tilt = -1;
					fqnode_data->fqnode.tilt = 0;
				    }
				}
#if ____CLASS_DELETE__ == __STACK_DELETE__
				fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
				    fwnode_data;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
				fvnode_data = fwnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
			    } else {
				struct fpnode_type *fmnode_data;

				fmnode_data = fxnode_data->fpnode_data[1];
				fqnode_data->fpnode_data[0] = fmnode_data;
				fxnode_data->fpnode_data[1] = fqnode_data;
#if ____CLASS_DELETE__ == __STACK_DELETE__
				fpmiss[miss - 1]->fpnode_data[data[miss - 1]] =
				    fxnode_data;
#elif __CLASS_DELETE__ == __TRACE_DELETE__
				fvnode_data = fxnode_data;
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */
				if (fxnode_data->fqnode.tilt) {
				    fqnode_data->fqnode.tilt = 0;
				    fxnode_data->fqnode.tilt = 0;
				} else {
				    fqnode_data->fqnode.tilt = -1;
				    fxnode_data->fqnode.tilt = 1;
#if ____CLASS_DELETE__ == __TRACE_DELETE__
				    slip |= 4096;
#elif __CLASS_DELETE__ == __STACK_DELETE__
				    break;
#endif				/* ____CLASS_DELETE__ == __TRACE_DELETE__ */
				}
			    }
			}
		    }
		}
	    }
	} while (0);
    }

    return status;
}
