/*
 * tcqp.l.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <tcqp-defs.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define tcline(tcline)			((struct tcline_type *) (tcline))

static int free_node(struct fpnode_type *, void *, int (*) (void *, void *));

static int
free_node(struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *))
{
    int status;

    do {
	struct fpnode_type *fqnode_data;

	fqnode_data = fpnode_data->fpnode_data[0];
	if (fqnode_data) {
	    status = free_node(fqnode_data, data, free);
	    if (status) {
		break;
	    }
	}

	fqnode_data = fpnode_data->fpnode_data[1];
	if (fqnode_data) {
	    status = free_node(fqnode_data, data, free);
	    if (status) {
		fpnode_data->fpnode_data[0] = NULL;

		break;
	    }
	}

	if (1) {
	    status = free(data, fpnode_data);
	    if (status) {
		status = FREE_ERROR;

		fpnode_data->fpnode_data[0] = NULL;
		fpnode_data->fpnode_data[1] = NULL;
	    }
	}
    } while (0);

    return status;
}


int
_libx1f4l2_ceil_tcline(void *tcline)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    if (fpnode_data) {
	status = free_node
	    (fpnode_data, tcline(tcline)->link_m.data,
	     tcline(tcline)->link_m.free);
    } else {
	status = 0;
    }

    return status;
}
