/*
 * tcqp.j.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-defs.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define tcline(tcline)			((struct tcline_type *) (tcline))

int
_libx1f4l2_beta_tcline(void *tcline, unsigned size, void **push)
{
    int status;
    void *tcnode;

    status = tcline(tcline)->link_m.link
	(tcline(tcline)->link_m.data, &tcnode,
	 sizeof(struct fpnode_type) + size);
    if (status) {
	status = LINK_ERROR;
    } else {
	*push = tcnode;
    }

    return status;
}
