/*
 * tcqp.e.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-config.h>

#include <tcqp-defs.h>
#include <tcqp-inter.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#if ____ELINK_TARGET__
# define __XLINK_TARGET__		1
#elif __QLINK_TARGET__
# define __XLINK_TARGET__		1
#else
# define __XLINK_TARGET__		0
#endif				/* ____ELINK_TARGET__ */

#define tcline(tcline)			((struct tcline_type *) (tcline))

#if __QLINK_TARGET__
static int free_ceil(struct tcline_type *);
#endif				/* __QLINK_TARGET__ */
#if __ELINK_TARGET__
static int free_lock(struct tcline_type *);
#endif				/* __ELINK_TARGET__ */

#if __QLINK_TARGET__
static int
free_ceil(struct tcline_type *tcline_data)
{
    int status;
    void *data;

    data = tcline_data->link_c.data;

    if (data) {
	status = tcline_data->link_m.free(tcline_data->link_m.data, data);
	if (status) {
	    status = FREE_ERROR;
	}
    } else {
	status = 0;
    }

    return status;
}
#endif				/* __QLINK_TARGET__ */


#if __ELINK_TARGET__
static int
free_lock(struct tcline_type *tcline_data)
{
    int status;
    void *data;

    data = tcline_data->link_e.fpmiss;

    if (data) {
	status = tcline_data->link_m.free(tcline_data->link_m.data, data);
	if (status) {
	    status = FREE_ERROR;
	}
    } else {
	status = 0;
    }

    return status;
}
#endif				/* __ELINK_TARGET__ */


int
x1f4_flat_tcline(void *tcline)
{
#if __XLINK_TARGET__
    int excess;
#endif				/* __XLINK_TARGET__ */
    int status;

    status = _libx1f4l2_ceil_tcline(tcline);
#if __ELINK_TARGET__
    excess = free_lock(tcline);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }
#endif				/* __ELINK_TARGET__ */
#if __QLINK_TARGET__
    excess = free_ceil(tcline);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }
#endif				/* __QLINK_TARGET__ */

    return status;
}
