/*
 * tcqp.7.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-names.h>
#include <tcqp-types.h>

#define __UNBALANCED__			1

#define Delete				0

#define tcline(tcline)			((struct tcline_type *) (tcline))

static int back_node(struct fpnode_type *, void *, int (*) (void *, void *));

static int
back_node(struct fpnode_type *fpnode_data, void *back,
	  int (*call) (void *, void *))
{
    int delete;

    do {
	struct fpnode_type *fqnode_data;

	fqnode_data = fpnode_data->fpnode_data[0];
	if (fqnode_data) {
#if __UNBALANCED__
	    struct fpnode_type *fsnode_data;
#endif				/* __UNBALANCED__ */

#if __UNBALANCED__
	    fsnode_data = fqnode_data->fpnode_data[0];
	    if (fsnode_data) {
		delete = back_node(fsnode_data, back, call);
		if (delete) {
		    break;
		}
	    }
#endif				/* __UNBALANCED__ */

#if __UNBALANCED__
	    if (1) {
		delete = call(back, fqnode_data + 1);
		if (delete) {
		    break;
		}
	    }
#else
	    delete = back_node(fqnode_data, back, call);
	    if (delete) {
		break;
	    }
#endif				/* __UNBALANCED__ */

#if __UNBALANCED__
	    fsnode_data = fqnode_data->fpnode_data[1];
	    if (fsnode_data) {
		delete = back_node(fsnode_data, back, call);
		if (delete) {
		    break;
		}
	    }
#endif				/* __UNBALANCED__ */
	}

	if (1) {
	    delete = call(back, fpnode_data + 1);
	    if (delete) {
		break;
	    }
	}

	fpnode_data = fpnode_data->fpnode_data[1];
    } while (fpnode_data);

    return delete;
}


int
x1f4_lime_tcline(void *tcline, void *back, int (*call) (void *, void *))
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    if (fpnode_data) {
	delete = back_node(fpnode_data, back, call);
    } else {
	delete = 0;
    }

    return delete;
}
