/*
 * tcqp-types.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_tcqp_types_H__
#define __LIBx1f4_tcqp_types_H__

#include <tcqp-config.h>

#include <trans.h>

#if ____FQNODE_CLASS__ == __SLICE_FQNODE__
typedef struct fbnode_type {
    unsigned short bits;
} fbnode_type;
#endif				/* ____FQNODE_CLASS__ == __SLICE_FQNODE__ */

typedef struct fqnode_type {
#if ____FQNODE_CLASS__ == __PLAIN_FQNODE__
    int tilt;
#elif __FQNODE_CLASS__ == __SLICE_FQNODE__
    short tilt;
    struct fbnode_type fbnode;
#endif				/* ____FQNODE_CLASS__ == __PLAIN_FQNODE__ */
} fqnode_type;

typedef struct fpnode_type {
    struct fpnode_type *fpnode_data[2];
    struct fqnode_type fqnode;
} fpnode_type;

typedef struct fpline_type {
    struct fpnode_type fplink;
} fpline_type;

typedef struct screen_type {
    struct trans_type *trans_data;
} screen_type;

typedef struct tcline_type {
    struct {
	struct fpline_type fpline;
    } link_a;
#if __QLINK_TARGET__
    struct {
	unsigned size;
	unsigned char *data;
    } link_c;
#endif				/* __QLINK_TARGET__ */
#if __ELINK_TARGET__
    struct {
	unsigned seek;
	struct fpnode_type **fpmiss;
    } link_e;
#endif				/* __ELINK_TARGET__ */
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} tcline_type;

#endif				/* __LIBx1f4_tcqp_types_H__ */
