/*
 * tcqp-inter.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_tcqp_inter_H__
#define __LIBx1f4_tcqp_inter_H__

#include <tcqp-names.h>
#include <tcqp-types.h>

#if !defined _libx1f4l2_fast_tcline
# define _libx1f4l2_fast_tcline		x1f4_fast_tcline
#endif				/* !_libx1f4l2_fast_tcline */
#if !defined _libx1f4l2_flat_tcline
# define _libx1f4l2_flat_tcline		x1f4_flat_tcline
#endif				/* !_libx1f4l2_flat_tcline */

extern int _libx1f4l2_beta_tcline(void *, unsigned, void **);
extern int _libx1f4l2_ceil_tcline(void *);
extern int _libx1f4l2_dana_tcline(void *, void *);
extern int _libx1f4l2_elif_tcline
    (void *, void *, int (*) (void *, void *), unsigned, unsigned, void **,
     int (*) (void *, unsigned, void **));
extern int _libx1f4l2_even_tcline
    (void *, void *, int (*) (void *, void *), unsigned, unsigned, void **,
     int (*) (void *, unsigned, void **));
extern int _libx1f4l2_fast_tcline(void *, unsigned, struct screen_type *);
extern int _libx1f4l2_flat_tcline(void *);
extern int _libx1f4l2_nand_tcline
    (void *, void *, int (*) (void *, void *), unsigned, void *,
     int (*) (void *, void *));

#endif				/* __LIBx1f4_tcqp_inter_H__ */
