/*
 * tcqp-config.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_tcqp_config_H__
#define __LIBx1f4_tcqp_config_H__

/*
 * insertion method definitions
 *
 * the SLICE method records direction choices (in the node records)
 * the STACK method employs some stack to keep track of its track
 * the TWICE method retests data to determine what the direction choices were
 */
#define __SLICE_INSERT__		1
#define __STACK_INSERT__		2
#define __TWICE_INSERT__		3

#define __CLASS_INSERT__		__SLICE_INSERT__

#define ____CLASS_INSERT__		__CLASS_INSERT__

/*
 * deletion method definitions
 *
 * the SLICE method reverses pointers as it goes to point up instead of down.
 *     it also uses some of the node records to record direction choices.
 * the STACK method employs some stack to keep track of its track
 * the TRACE method reverses pointers as it goes to point up instead of down.
 *     it determines direction choices by comparing some pointers.
 */
#define __SLICE_DELETE__		1
#define __STACK_DELETE__		2
#define __TRACE_DELETE__		3

#define __CLASS_DELETE__		__SLICE_DELETE__

#define ____CLASS_DELETE__		__CLASS_DELETE__

#if ____CLASS_INSERT__ == __SLICE_INSERT__
# define __QLINK_INSERT__		0
#elif __CLASS_INSERT__ == __STACK_INSERT__
# define __QLINK_INSERT__		1
#elif __CLASS_INSERT__ == __TWICE_INSERT__
# define __QLINK_INSERT__		0
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_DELETE__ == __SLICE_DELETE__
# define __ELINK_DELETE__		0
#elif __CLASS_DELETE__ == __STACK_DELETE__
# define __ELINK_DELETE__		1
#elif __CLASS_DELETE__ == __TRACE_DELETE__
# define __ELINK_DELETE__		0
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#if ____CLASS_DELETE__ == __SLICE_DELETE__
# define __QLINK_DELETE__		0
#elif __CLASS_DELETE__ == __STACK_DELETE__
# define __QLINK_DELETE__		1
#elif __CLASS_DELETE__ == __TRACE_DELETE__
# define __QLINK_DELETE__		0
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#define ____QLINK_INSERT__		__QLINK_INSERT__

#if ____QLINK_INSERT__
# define __QLINK_TARGET__		1
#elif __QLINK_DELETE__
# define __QLINK_TARGET__		1
#else
# define __QLINK_TARGET__		0
#endif				/* ____QLINK_INSERT__ */

#if 1
# define ____QLINK_TARGET__		__QLINK_TARGET__
#endif				/* 1 */

#define ____ELINK_DELETE__		__ELINK_DELETE__

#if ____ELINK_DELETE__
# define __ELINK_TARGET__		1
#else
# define __ELINK_TARGET__		0
#endif				/* ____ELINK_DELETE__ */

#if 1
# define ____ELINK_TARGET__		__ELINK_TARGET__
#endif				/* 1 */

#define __PLAIN_FQNODE__		1
#define __SLICE_FQNODE__		2

#if ____CLASS_INSERT__ == __SLICE_INSERT__
# define __BREAK_INSERT__		1
#elif __CLASS_INSERT__ == __STACK_INSERT__
# define __BREAK_INSERT__		0
#elif __CLASS_INSERT__ == __TWICE_INSERT__
# define __BREAK_INSERT__		0
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#define ____BREAK_INSERT__		__BREAK_INSERT__

#if ____CLASS_DELETE__ == __SLICE_DELETE__
# define __BREAK_DELETE__		1
#elif __CLASS_DELETE__ == __STACK_DELETE__
# define __BREAK_DELETE__		0
#elif __CLASS_DELETE__ == __TRACE_DELETE__
# define __BREAK_DELETE__		0
#endif				/* ____CLASS_DELETE__ == __STACK_DELETE__ */

#define ____BREAK_DELETE__		__BREAK_DELETE__

#if ____BREAK_INSERT__
#define __FQNODE_CLASS__		__SLICE_FQNODE__
#elif __BREAK_DELETE__
#define __FQNODE_CLASS__		__SLICE_FQNODE__
#else
#define __FQNODE_CLASS__		__PLAIN_FQNODE__
#endif				/* ____BREAK_INSERT__ */

#define ____FQNODE_CLASS__		__FQNODE_CLASS__

#endif				/* __LIBx1f4_tcqp_config_H__ */
