/*
 * tcline.h
 * Copyright (C) 2008-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_TCLINE_H__
#define __LIBx1f4_TCLINE_H__

#include <errors.h>
#include <tcqp-names.h>

/*
 * attribute bit definitions
 */
#define X1f4_TCLINE_TRANS_MASK		(1u << 0x00)

/*
 * error definitions
 */
#define X1f4_TCLINE_DECK_ERROR		LIBx1f4L2_DECK_ERROR
#define X1f4_TCLINE_FREE_ERROR		LIBx1f4L2_FREE_ERROR
#define X1f4_TCLINE_LINK_ERROR		LIBx1f4L2_LINK_ERROR
#define X1f4_TCLINE_MODE_ERROR		LIBx1f4L2_MODE_ERROR

/*
 * error definitions (continued)
 */
#define X1f4_TCLINE_EVER_MATCH		LIBx1f4L2_EVER_MATCH
#define X1f4_TCLINE_MISS_CLASS		LIBx1f4L2_MISS_CLASS

typedef struct x1f4_tcline_type {
    void *trans;
} x1f4_tcline_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_base_tcline(unsigned *);
extern int x1f4_call_tcline(unsigned *);
extern int x1f4_case_tcline(void *);
extern int x1f4_cast_tcline
    (void *, void *, int (*) (void *, void *), unsigned);
extern int x1f4_ever_tcline(void *, void **);
extern int x1f4_fast_tcline(void *, unsigned, struct x1f4_tcline_type *);
extern int x1f4_fgxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_find_tcclip
    (void *, unsigned long, unsigned, void **);
extern int x1f4_find_tcfine
    (void *, unsigned, unsigned, void **);
extern int x1f4_find_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_find_tcword
    (void *, const unsigned char *, unsigned, void **);
extern int x1f4_fini_tcline(void **);
extern int x1f4_flat_tcline(void *);
extern int x1f4_fmxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_fxxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_high_tcline(void *);
extern int x1f4_init_tcline(void **, unsigned, struct x1f4_tcline_type *);
extern int x1f4_land_tcline
    (void *, void *, int (*) (void *, void *), unsigned, unsigned, void **);
extern int x1f4_lead_tcline(void *, void **);
extern int x1f4_lime_tcline(void *, void *, int (*) (void *, void *));
extern int x1f4_llxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_lmxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_lxxd_tcline
    (void *, void *, unsigned, int (*) (void *, void *), void **);
extern int x1f4_near_tcline
    (void *, void *, int (*) (void *, void *), unsigned, void *,
     int (*) (void *, void *));
extern int x1f4_pass_tcline
    (void *, void *, int (*) (void *, void *), unsigned);
extern int x1f4_post_tcline
    (void *, void *, int (*) (void *, void *), unsigned, unsigned, void **);
extern int x1f4_scan_tcline
    (void *, void *, int (*) (void *, void *, unsigned));
extern int x1f4_shut_tcline
    (void *, void *, int (*) (void *, void *), unsigned, void *,
     int (*) (void *, void *));
extern int x1f4_skew_tcline(void *, void *);

#endif				/* __LIBx1f4_TCLINE_H__ */
