/*
 * sstring.v.c
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined LIBx1f4i0
# include <cstring.vf.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

static const char escapes[] = "abtnvfr";
static const unsigned c_type_0[] = {
/*
 * . . . . . . .               . .
 * . . . . . . . . . . . . . . . .
 *
 *
 *
 *
 *
 *                               .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 */
/* *INDENT-OFF* */
    0xffffc07f, 0x00000000, 0x00000000, 0x80000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
/* *INDENT-ON* */
}, c_type_1[] = {
/*
 *               . . . . . . .
 *
 *     "
 *
 *
 *                         \
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00003f80, 0x00000004, 0x10000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_vprint_sstring(void *data, int (*this) (void *, const char *, unsigned),
		    const char *name, const unsigned *c_type_x)
{
    int status = 0;
    unsigned byte, deck = 0, miss = ~0;

    byte = *(const unsigned char *) name;
    while (byte) {
	if (C_TYPE_X(c_type_0, byte)) {
	    if (~miss) {
		status = x1f4_vflush_cstring(data, this, 0, &miss);
		if (status) {
		    break;
		}
	    } else {
		if (deck) {
		    status = this(data, name - deck, deck);
		    if (status) {
			break;
		    } else {
			deck = 0;
		    }
		}
	    }
	    if (byte < 64) {
		miss = byte;
	    } else {
		char aime[4];

		aime[0] = '\\';
		aime[1] = ((byte >> 6) & 0x07) + 0x30;
		aime[2] = ((byte >> 3) & 0x07) + 0x30;
		aime[3] = ((byte >> 0) & 0x07) + 0x30;
		status = this(data, aime, 4);
		if (status) {
		    break;
		}
	    }
	} else {
	    if (~miss) {
		status = x1f4_vflush_cstring
		    (data, this, 0x2f < byte && byte < 0x38, &miss);
		if (status) {
		    break;
		}
	    }
	    if (C_TYPE_X(c_type_1, byte)) {
		if (deck) {
		    status = this(data, name - deck, deck);
		    if (status) {
			break;
		    } else {
			deck = 0;
		    }
		}
		{
		    char aime[2];

		    aime[0] = '\\';
		    if (byte == 0x22) {
			aime[1] = '"';
		    } else {
			if (byte == 0x5c) {
			    aime[1] = '\\';
			} else {
			    aime[1] = escapes[byte - 0x07];
			}
		    }
		    status = this(data, aime, 2);
		    if (status) {
			break;
		    }
		}
	    } else {
		if (C_TYPE_X(c_type_x, byte)) {
		    if (deck) {
			status = this(data, name - deck, deck);
			if (status) {
			    break;
			} else {
			    deck = 0;
			}
		    }
		    {
			char aime[2];

			aime[0] = '\\';
			aime[1] = byte;
			status = this(data, aime, 2);
			if (status) {
			    break;
			}
		    }
		} else {
		    deck++;
		}
	    }
	}

	name++;
	byte = *(const unsigned char *) name;
    }
    if (~miss) {
	if (1) {
	    if (!status) {
		status = x1f4_vflush_cstring(data, this, 0, &miss);
	    }
	}
    } else {
	if (deck) {
	    if (!status) {
		if (1) {
		    status = this(data, name - deck, deck);
		}
	    }
	}
    }

    return status;
}
