/*
 * sfnote.h
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_SFNOTE_H__
#define __LIBx1f4_SFNOTE_H__

#include <errors.h>
#include <sfas-names.h>

/*
 * attribute bit definitions
 */
#define X1f4_SFNOTE_TRANS_MASK		(1u << 0x00)

/*
 * error definitions
 */
#define X1f4_SFNOTE_CALL_ERROR		LIBx1f4L2_CALL_ERROR
#define X1f4_SFNOTE_DECK_ERROR		LIBx1f4L2_DECK_ERROR
#define X1f4_SFNOTE_FREE_ERROR		LIBx1f4L2_FREE_ERROR
#define X1f4_SFNOTE_LINK_ERROR		LIBx1f4L2_LINK_ERROR
#define X1f4_SFNOTE_MODE_ERROR		LIBx1f4L2_MODE_ERROR
#define X1f4_SFNOTE_SIZE_ERROR		LIBx1f4L2_SIZE_ERROR

/*
 * error definitions (continued)
 */
#define X1f4_SFNOTE_EVER_MATCH		LIBx1f4L2_EVER_MATCH
#define X1f4_SFNOTE_MISS_CLASS		LIBx1f4L2_MISS_CLASS

typedef struct x1f4_sfnote_type {
    void *trans;
} x1f4_sfnote_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_call_sfnote(unsigned *);
extern int x1f4_case_sfnote(void *);
extern int x1f4_cast_sfnote(void *, const char *);
extern int x1f4_drop_sfnote
    (void *, const char *, void *, int (*) (void *, void *));
extern int x1f4_ever_sfnote(void *, void **);
extern int x1f4_fast_sfnote(void *, unsigned, struct x1f4_sfnote_type *);
extern int x1f4_fgxq_sfnote
    (void *, const char *, void **, const char **, unsigned *);
extern int x1f4_find_sfnote(void *, const char *, void **);
extern int x1f4_fini_sfnote(void **);
extern int x1f4_flat_sfnote(void *);
extern int x1f4_fold_sfnote(void *, void **, const char **, unsigned *);
extern int x1f4_high_sfnote(void *);
extern int x1f4_hike_sfnote(void *, void **, const char **, unsigned *);
extern int x1f4_init_sfnote(void **, unsigned, struct x1f4_sfnote_type *);
extern int x1f4_lead_sfnote(void *, void **);
extern int x1f4_lime_sfnote(void *, void *, int (*) (void *, void *));
extern int x1f4_line_sfnote
    (void *, void *, int (*) (void *, unsigned *, const void *),
     int (*) (void *, void *, const void *), int (*) (void *, void *), void *);
extern int x1f4_llxq_sfnote
    (void *, const char *, void **, const char **, unsigned *);
extern int x1f4_mind_sfnote(void *);
extern int x1f4_note_sfnote
    (void *, void *, int (*) (void *, const char *, unsigned));
extern int x1f4_pass_sfnote(void *, const char *);
extern int x1f4_post_sfnote(void *, const char *, unsigned, void **);
extern int x1f4_shut_sfnote
    (void *, const char *, void *, int (*) (void *, void *));
extern int x1f4_skew_sfnote(void *, void *);
extern int x1f4_slip_sfnote(void *);
extern int x1f4_span_sfnote
    (void *, void *, int (*) (void *, void *, const char *, unsigned));
extern int x1f4_swap_sfnote(void *, void *);
extern int x1f4_text_sfnote
    (void **, void *, int (*) (void *, unsigned *, const void *),
     int (*) (void *, void *, const void *), int (*) (void *, void *), void *);

#endif				/* __LIBx1f4_SFNOTE_H__ */
