/*
 * sfas.t.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <sfas-defs.h>
#include <sfas-inter.h>
#include <sfas-names.h>
#include <sfas-types.h>
#include <trans.h>

#define back(miss)			((const char *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int back_aime(struct sfnote_type *, struct fpnode_type *, unsigned,
		     int (*) (void *, void *), void *);
static int back_node(struct sfnote_type *, struct fpnode_type *,
		     int (*) (void *, void *), void *);
static int copy_aime(struct sfnote_type *, struct fpnode_type *,
		     const struct fpnode_type *,
		     int (*) (void *, unsigned *, const void *),
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);
static int copy_back(struct sfnote_type *, struct fpnode_type *,
		     const struct fpnode_type *,
		     int (*) (void *, unsigned *, const void *),
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);

static int
back_aime(struct sfnote_type *sfnote_data, struct fpnode_type *fpnode_data,
	  unsigned spread, int (*free) (void *, void *), void *context)
{
    while (spread) {
	spread--;
	fpnode_data--;
	back_node(sfnote_data, fpnode_data, free, context);
    }

    return -1;
}


static int
back_node(struct sfnote_type *sfnote_data, struct fpnode_type *fpnode_data,
	  int (*free) (void *, void *), void *context)
{
    unsigned bits;

    bits = fpnode_data->bits;

    if (Extant(bits)) {
	unsigned spread;
	void *data;

	data = (void *) fpnode_data->data;

	spread = Spread(bits);

	back_aime
	    (sfnote_data, (struct fpnode_type *) data + spread, spread,
	     free, context);

	sfnote_data->link_m.free(sfnote_data->link_m.data, data);

	if (sizeof(byte *) < Length(bits)) {
	    sfnote_data->link_m.free
		(sfnote_data->link_m.data, fpnode_data->base);
	}
    } else {
	void *data;

	data = fpnode_data->data;

	free(context, data);

	sfnote_data->link_m.free(sfnote_data->link_m.data, data);
    }

    return -1;
}


static int
copy_aime(struct sfnote_type *sfnote_data, struct fpnode_type *fpnode_data,
	  const struct fpnode_type *fpnode_fast,
	  int (*size) (void *, unsigned *, const void *),
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    int status;
    unsigned bits, spread;
    void *data;

    bits = fpnode_fast->bits;

    spread = Spread(bits);

    status = sfnote_data->link_m.link
	(sfnote_data->link_m.data, &data,
	 ((spread + 3) & ~3) * sizeof(struct fpnode_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	struct fpnode_type *fpnode_slip;
	const struct fpnode_type *fpnode_text;

	fpnode_slip = data;
	fpnode_text = fpnode_fast->data;

	while (1) {
	    status = copy_back
		(sfnote_data, fpnode_slip, fpnode_text, size, copy, free,
		 context);
	    if (status) {
		break;
	    } else {
		spread--;
		if (spread) {
		    fpnode_slip++;
		    fpnode_text++;
		} else {
		    break;
		}
	    }
	}

	if (status) {
	    back_aime
		(sfnote_data, fpnode_slip,
		 fpnode_slip - (struct fpnode_type *) data, free, context);

	    sfnote_data->link_m.free(sfnote_data->link_m.data, data);
	} else {
	    fpnode_data->data = data;
	}
    }

    return status;
}


static int
copy_back(struct sfnote_type *sfnote_data, struct fpnode_type *fpnode_data,
	  const struct fpnode_type *fpnode_fast,
	  int (*size) (void *, unsigned *, const void *),
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    byte *base;
    int status;
    unsigned bits, length;

    bits = fpnode_fast->bits;

    base = fpnode_fast->base;

    length = Length(bits);

    fpnode_data->bits = bits;

    if (Extant(bits)) {
	if (sizeof(byte *) < length) {
	    void *data;

	    if (length < Record) {
	    } else {
		length += strlen(back(base) + Record);
	    }

	    length++;

	    status = sfnote_data->link_m.link
		(sfnote_data->link_m.data, &data, length);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		status = copy_aime
		    (sfnote_data, fpnode_data, fpnode_fast, size, copy, free,
		     context);
		if (status) {
		    sfnote_data->link_m.free(sfnote_data->link_m.data, data);
		} else {
		    fpnode_data->base = data;
		    memcpy(data, base, length);
		}
	    }
	} else {
	    memcpy(&fpnode_data->base, &base, length);

	    status = copy_aime
		(sfnote_data, fpnode_data, fpnode_fast, size, copy, free,
		 context);
	}
    } else {
	unsigned slip;
	void *data;

	if (length < Record) {
	} else {
	    length += strlen(back(base) + Record);
	}

	length++;

	size(context, &slip, fpnode_fast->data);

	status = sfnote_data->link_m.link
	    (sfnote_data->link_m.data, &data, slip + length);
	if (status) {
	    status = LINK_ERROR;
	} else {
	    status = copy(context, data, fpnode_fast->data);
	    if (status) {
		status = CALL_ERROR;
		if (1) {
		    sfnote_data->link_m.free(sfnote_data->link_m.data, data);
		}
	    } else {
		fpnode_data->data = data;

		data = (byte *) data + slip;

		fpnode_data->base = data;

		memcpy(data, base, length);
	    }
	}
    }

    return status;
}


int
_libx1f4l2_rail_sfnote(void *scdata, void *sctext,
		       int (*size) (void *, unsigned *, const void *),
		       int (*copy) (void *, void *, const void *),
		       int (*free) (void *, void *), void *context)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sctext)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	void *data;

	status = sfnote(scdata)->link_m.link
	    (sfnote(scdata)->link_m.data, &data, sizeof(struct fpnode_type));
	if (status) {
	    status = LINK_ERROR;
	} else {
	    status = copy_back
		(scdata, data, fpnode_data, size, copy, free, context);
	    if (status) {
		sfnote(scdata)->link_m.free(sfnote(scdata)->link_m.data, data);
	    } else {
		sfnote(scdata)->link_a.fpdeck.fpnode_data = data;
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
