/*
 * sfas.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int case_link(void *, struct fpnode_type *);
static int free_list(void *, struct fpnode_type *, void *,
		     int (*) (void *, void *), void *,
		     int (*) (void *, void *), int *);
static int free_node(void *, struct fpnode_type *, void *,
		     int (*) (void *, void *), void *,
		     int (*) (void *, void *), int *);

static int
case_link(void *sfnote, struct fpnode_type *fpnode_slip)
{
    byte *base, *lock;
    int prefix, status;
    struct fpnode_type *fpnode_data;
    unsigned bits, length, miss, offset;

    bits = fpnode_slip->bits;

    base = fpnode_slip->base;

    length = Length(bits);
    if (length < Record) {
    } else {
	length += strlen(back(base) + Record);
    }

    fpnode_data = fpnode_slip->data;

    prefix = Prefix(bits);

    miss = fpnode_data->bits;

    lock = fpnode_data->base;

    if (prefix) {
	if (Extant(miss)) {
	    if (Prefix(miss)) {
		offset = Length(miss);
		if (offset < Record) {
		    if (sizeof(byte *) < offset) {
		    } else {
			lock = (byte *) &fpnode_data->base;
		    }
		} else {
		    offset += strlen(back(lock) + Record);
		}

		offset++;
	    } else {
		offset = 0;
	    }
	} else {
	    offset = 0;
	}
    } else {
	offset = 0;
    }

    if (offset) {
	do {
	    unsigned mirror;
	    void *copy;

	    mirror = length + offset;

	    if (sizeof(byte *) < mirror) {
		if (sizeof(byte *) < length) {
		    copy = base;
		    status = sfnote(sfnote)->link_m.mode
			(sfnote(sfnote)->link_m.data, &copy, mirror + 1);
		    if (status) {
			status = MODE_ERROR;
		    } else {
			fpnode_slip->base = copy;
		    }
		} else {
		    status = sfnote(sfnote)->link_m.link
			(sfnote(sfnote)->link_m.data, &copy, mirror + 1);
		    if (status) {
			status = LINK_ERROR;
		    } else {
			memcpy(copy, &fpnode_slip->base, length);
			fpnode_slip->base = copy;
		    }
		}
	    } else {
		copy = &fpnode_slip->base;
		if (1) {
		    status = 0;
		}
	    }
	    if (status) {
		sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, (void *) fpnode_slip->data);
		if (sizeof(byte *) < length) {
		    sfnote(sfnote)->link_m.free
			(sfnote(sfnote)->link_m.data, base);
		}

		*fpnode_slip = *fpnode_data;
	    } else {
		byte *deck;
		void *slip;

		deck = copy;
		deck += length;
		*deck = Prefix(miss);
		deck++;
		offset--;
		if (offset) {
		    memcpy(deck, lock, offset);
		    if (1) {
			deck += offset;
		    }
		}

		if (sizeof(byte *) < mirror) {
		    *deck = 0;
		}

		slip = (void *) fpnode_slip->data;

		fpnode_slip->bits = pset(prefix, mirror, miss);
		fpnode_slip->data = fpnode_data->data;

		status = sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, slip);
		if (status) {
		    status = FREE_ERROR;
		} else {
		    if (sizeof(byte *) < offset) {
			status = sfnote(sfnote)->link_m.free
			    (sfnote(sfnote)->link_m.data, lock);
			if (status) {
			    status = FREE_ERROR;
			}
		    }
		}
	    }
	} while (0);
    } else {
	void *link;

	link = fpnode_data->data;

	status = sfnote(sfnote)->link_m.free
	    (sfnote(sfnote)->link_m.data, (void *) fpnode_slip->data);
	if (status) {
	    status = FREE_ERROR;
	} else {
	    if (Extant(miss)) {
		if (prefix) {
		    /* this can never be */
		    fpnode_slip->bits = pset(prefix, length, miss);
		} else {
		    fpnode_slip->bits = miss;
		}
	    } else {
		if (prefix) {
		    fpnode_slip->bits = zset(miss, prefix);
		} else {
		    fpnode_slip->bits = miss;
		}
	    }

	    fpnode_slip->base = lock;
	    fpnode_slip->data = link;

	    if (sizeof(byte *) < length) {
		status = sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, base);
		if (status) {
		    status = FREE_ERROR;
		}
	    }
	}
    }

    return status;
}


static int
free_list(void *sfnote, struct fpnode_type *fpnode_fast, void *data,
	  int (*free) (void *, void *), void *back,
	  int (*call) (void *, void *), int *error)
{
    int excess, status = 0;
    struct fpnode_type *fpnode_data, *fpnode_slip, *fpnode_text;
    unsigned bits, size;

    bits = fpnode_fast->bits;

    size = Spread(bits);

    fpnode_slip = (struct fpnode_type *) fpnode_fast->data;

    fpnode_data = fpnode_slip;

    fpnode_text = fpnode_slip;

    while (1) {
	excess = free_node(sfnote, fpnode_data, data, free, back, call, error);
	if (excess) {
	    status = CALL_ERROR;
	    *fpnode_text++ = *fpnode_data;
	}

	size--;
	if (size) {
	    fpnode_data++;
	} else {
	    break;
	}
    }

    if (status) {
	fpnode_fast->bits = iset(bits, fpnode_text - fpnode_slip);
    } else {
	excess = free(data, fpnode_slip);
	if (excess) {
	    if (*error) {
	    } else {
		*error = FREE_ERROR;
	    }
	}
    }

    return status;
}


static int
free_node(void *sfnote, struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *), void *back,
	  int (*call) (void *, void *), int *error)
{
    int excess, status;
    unsigned bits;

    bits = fpnode_data->bits;
    if (Extant(bits)) {
	status = free_list(sfnote, fpnode_data, data, free, back, call, error);
	if (status) {
	    unsigned size;

	    size = effect(fpnode_data);
	    if (size) {
		size += 4;
		size &= ~3;
		if (size != ((Spread(bits) + 3) & ~3)) {
		    void *list;

		    list = (void *) fpnode_data->data;

		    excess = sfnote(sfnote)->link_m.mode
			(sfnote(sfnote)->link_m.data, &list,
			 sizeof(struct fpnode_type) * size);
		    if (excess) {
			if (*error) {
			} else {
			    *error = MODE_ERROR;
			}
		    } else {
			fpnode_data->data = list;
		    }
		}
	    } else {
		excess = case_link(sfnote, fpnode_data);
		if (*error) {
		} else {
		    *error = excess;
		}
	    }
	} else {
	    if (sizeof(byte *) < length(fpnode_data)) {
		excess = free(data, fpnode_data->base);
		if (excess) {
		    if (*error) {
		    } else {
			*error = FREE_ERROR;
		    }
		}
	    }
	}
    } else {
	void *late;

	late = fpnode_data->data;

	status = call(back, late);
	if (status) {
	    status = CALL_ERROR;
	} else {
	    excess = free(data, late);
	    if (excess) {
		if (*error) {
		} else {
		    *error = FREE_ERROR;
		}
	    }
	}
    }

    return status;
}


int
_libx1f4l2_hale_sfnote(void *sfnote, struct fpnode_type *fpnode_data,
		       void *back, int (*call) (void *, void *), int *error)
{
    return free_node
	(sfnote, fpnode_data, sfnote(sfnote)->link_m.data,
	 sfnote(sfnote)->link_m.free, back, call, error);
}
