/*
 * sfas.k.c
 * Copyright (C) 2009-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sfas-defs.h>
#include <sfas-inter.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
_libx1f4l2_blue_sfnote(void *sfnote, struct fpnode_type *fpnode_slip,
		       struct fpnode_type *fpnode_data)
{
    int status;

    do {
	status = sfnote(sfnote)->link_m.free
	    (sfnote(sfnote)->link_m.data, (void *) fpnode_data->data);
	if (status) {
	    status = FREE_ERROR;
	    if (1) {
		break;
	    }
	}

	status = _libx1f4l2_yank_sfnote(sfnote, fpnode_slip, fpnode_data);
    } while (0);

    return status;
}
