/*
 * sfas.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int free_list(struct fpnode_type *, void *, int (*) (void *, void *));
static int free_node(struct fpnode_type *, void *, int (*) (void *, void *));

static int
free_list(struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *))
{
    int excess, status = 0;
    struct fpnode_type *fpnode_slip;
    unsigned size;

    size = spread(fpnode_data);

    fpnode_slip = (struct fpnode_type *) fpnode_data->data;

    fpnode_data = fpnode_slip;

    while (1) {
	excess = free_node(fpnode_data, data, free);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	size--;
	if (size) {
	    fpnode_data++;
	} else {
	    excess = free(data, fpnode_slip);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }

	    if (4) {
		break;
	    }
	}
    }

    return status;
}


static int
free_node(struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *))
{
    int excess, status;

    if (extant(fpnode_data)) {
	if (sizeof(byte *) < length(fpnode_data)) {
	    status = free(data, fpnode_data->base);
	    if (status) {
		status = FREE_ERROR;
	    }
	} else {
	    status = 0;
	}

	excess = free_list(fpnode_data, data, free);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    } else {
	status = free(data, fpnode_data->data);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


int
x1f4_flat_sfnote(void *sfnote)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	status = free_node
	    (fpnode_data, sfnote(sfnote)->link_m.data,
	     sfnote(sfnote)->link_m.free);
	if (status) {
	} else {
	    status = sfnote(sfnote)->link_m.free
		(sfnote(sfnote)->link_m.data, fpnode_data);
	    if (status) {
		status = FREE_ERROR;
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
