/*
 * sfas.0.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <mask.0.h>
#include <sfas-defs.h>
#include <sfas-inter.h>
#include <sfas-names.h>
#include <sfas-types.h>
#include <trans.h>

int
x1f4_init_sfnote(void **sfnote, unsigned flags,
		 struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *text;

    if (flags & TRANS_MASK) {
	struct trans_type *trans_data;

	trans_data = screen_data->trans_data;

	link = trans_data->link;
	text = trans_data->data;
    } else {
	link = _libx1f4l2_link_data;
	text = (void *) 0;
    }

    status = link(text, &text, sizeof(struct sfnote_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	struct sfnote_type *sfnote_data;

	sfnote_data = text;

	_libx1f4l2_fast_sfnote(sfnote_data, flags, screen_data);

	if (0) {
	} else {
	    *sfnote = text;
	}
    }

    return status;
}
