/*
 * sfas-patch.h
 * Copyright (C) 2009-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_sfas_patch_H__
#define __LIBx1f4_sfas_patch_H__

#include <string.h>

#include <sfas-defs.h>

#define Dispatch_node(fpnode_data, ___b, c, dispatch_miss) \
    {									      \
	byte *pick;							      \
	unsigned size;							      \
									      \
	size = Effect(___b);						      \
	fpnode_data = (struct fpnode_type *) fpnode_data->data;		      \
	pick = (void *) fpnode_data;					      \
	pick += prefixof();						      \
	while (2 < size) {						      \
	    byte *lock;							      \
	    unsigned half;						      \
									      \
	    half = (size + 1) >> 1;					      \
	    lock = pick + half * sizeof(struct fpnode_type);		      \
	    if (c < *lock) {						      \
		size = half - 1;					      \
		half >>= 1;						      \
		lock = pick + half * sizeof(struct fpnode_type);	      \
		if (c < *lock) {					      \
		    size = half - 1;					      \
		} else {						      \
		    pick = lock;					      \
		    size >>= 1;						      \
		}							      \
	    } else {							      \
		size >>= 1;						      \
		half = (size + 1) >> 1;					      \
		pick = lock + half * sizeof(struct fpnode_type);	      \
		if (c < *pick) {					      \
		    pick = lock;					      \
		    size = half - 1;					      \
		} else {						      \
		    size >>= 1;						      \
		}							      \
	    }								      \
	}								      \
	if (size == 1) {						      \
	    byte *lock;							      \
									      \
	    lock = pick + sizeof(struct fpnode_type);			      \
	    if (c < *lock) {						      \
	    } else {							      \
		pick = lock;						      \
	    }								      \
	} else {							      \
	    if (size) {							      \
		byte *lock;						      \
									      \
		lock = pick + sizeof(struct fpnode_type);		      \
		if (c < *lock) {					      \
		} else {						      \
		    pick = lock + sizeof(struct fpnode_type);		      \
		    if (c < *pick) {					      \
			pick = lock;					      \
		    } else {						      \
		    }							      \
		}							      \
	    }								      \
	}								      \
	e = *pick;							      \
	pick -= prefixof();						      \
	fpnode_data = (void *) pick;					      \
	{								      \
	    if (e != c) {						      \
		dispatch_miss;						      \
	    } else {							      \
		unsigned bits;						      \
									      \
		bits = fpnode_data->bits;				      \
		length = Length(bits);					      \
		if (Extant(bits)) {					      \
		    if (sizeof(byte *) < length) {			      \
			slip = fpnode_data->base;			      \
			if (length < Record) {				      \
			} else {					      \
			    length += strlen(back(slip) + Record);	      \
			}						      \
		    } else {						      \
			slip = (byte *) &fpnode_data->base;		      \
		    }							      \
		} else {						      \
		    unsigned offset;					      \
									      \
		    offset = name - lead;				      \
									      \
		    slip = fpnode_data->base;				      \
									      \
		    if (length < Record) {				      \
		    } else {						      \
			length += strlen(back(slip) + Record);		      \
		    }							      \
									      \
		    slip += offset;					      \
		    length -= offset;					      \
		}							      \
	    }								      \
	}								      \
    }

#define Progress_node(fpnode_data, mind) \
    {									      \
	byte *pick;							      \
	unsigned size;							      \
									      \
	size = (mind);							      \
	pick = (void *) (fpnode_data);					      \
	pick += prefixof();						      \
	while (2 < size) {						      \
	    byte *lock;							      \
	    unsigned half;						      \
									      \
	    half = (size + 1) >> 1;					      \
	    lock = pick + half * sizeof(struct fpnode_type);		      \
	    if (c < *lock) {						      \
		size = half - 1;					      \
		half >>= 1;						      \
		lock = pick + half * sizeof(struct fpnode_type);	      \
		if (c < *lock) {					      \
		    size = half - 1;					      \
		} else {						      \
		    pick = lock;					      \
		    size >>= 1;						      \
		}							      \
	    } else {							      \
		size >>= 1;						      \
		half = (size + 1) >> 1;					      \
		pick = lock + half * sizeof(struct fpnode_type);	      \
		if (c < *pick) {					      \
		    pick = lock;					      \
		    size = half - 1;					      \
		} else {						      \
		    size >>= 1;						      \
		}							      \
	    }								      \
	}								      \
	if (size == 1) {						      \
	    byte *lock;							      \
									      \
	    lock = pick + sizeof(struct fpnode_type);			      \
	    if (c < *lock) {						      \
	    } else {							      \
		pick = lock;						      \
	    }								      \
	} else {							      \
	    if (size) {							      \
		byte *lock;						      \
									      \
		lock = pick + sizeof(struct fpnode_type);		      \
		if (c < *lock) {					      \
		} else {						      \
		    pick = lock + sizeof(struct fpnode_type);		      \
		    if (c < *pick) {					      \
			pick = lock;					      \
		    } else {						      \
		    }							      \
		}							      \
	    }								      \
	}								      \
									      \
	pick -= prefixof();						      \
	fpnode_data = (void *) pick;					      \
    }

#define dispatch_node(fpnode_data, bits, c) \
    Dispatch_node((fpnode_data), (bits), (c), ___dispatch_miss)

#define dispatch_shut(fpnode_data, bits, c) \
    Dispatch_node((fpnode_data), (bits), (c), ___dispatch_post)

#define dispatch_slip(fpnode_data, bits, c) \
    Dispatch_node((fpnode_data), (bits), (c), ___dispatch_none)

#define ___dispatch_miss \
		delete = 0;						      \
		if (1) {						      \
		    break;						      \
		}

#define ___dispatch_none \
		status = 0;						      \
		if (1) {						      \
		    break;						      \
		}

#define ___dispatch_post \
		status = MISS_CLASS;					      \
		if (1) {						      \
		    break;						      \
		}

#endif				/* __LIBx1f4_sfas_patch_H__ */
