/*
 * sfar.m.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sfas-defs.h>
#include <sfas-inter.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int fini_deck(void **);
static int init_deck(void **, struct sfnote_type *);

static int
fini_deck(void **text)
{
    return _libx1f4l2_fini_sfnote(text);
}


static int
init_deck(void **text, struct sfnote_type *sfnote_data)
{
    int status;
    struct screen_type screen;
    struct trans_type trans;

    screen.trans_data = &trans;

    trans.data = sfnote_data->link_m.data;
    trans.free = sfnote_data->link_m.free;
    trans.link = sfnote_data->link_m.link;
    trans.mode = sfnote_data->link_m.mode;

    status = _libx1f4l2_init_sfnote(text, TRANS_MASK, &screen);

    return status;
}


int
x1f4_text_sfnote(void **sfnote, void *sctext,
		 int (*size) (void *, unsigned *, const void *),
		 int (*copy) (void *, void *, const void *),
		 int (*free) (void *, void *), void *context)
{
    int status;
    void *text;

    status = init_deck(&text, sctext);
    if (status) {
    } else {
	status = _libx1f4l2_rail_sfnote
	    (text, sctext, size, copy, free, context);
	if (status) {
	    fini_deck(&text);
	} else {
	    *sfnote = text;
	}
    }

    return status;
}
