/*
 * sfap.3.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <sfas-inter.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
x1f4_mind_sfnote(void *sfnote)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	struct fpnode_type *fpnode_slip = NULL;

	while (1) {
	    if (extant(fpnode_data)) {
		fpnode_slip = fpnode_data;
		fpnode_data = (void *) fpnode_data->data;
	    } else {
		if (fpnode_slip) {
		    status = _libx1f4l2_blue_sfnote
			(sfnote, fpnode_slip, fpnode_data);
		} else {
		    status = _libx1f4l2_fail_sfnote(sfnote, fpnode_data);
		}

		break;
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
