/*
 * s5xx.d.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <s5xx-names.h>
#include <s5xx-types.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

static int back_node(const struct fpnode_type *, void *,
		     int (*) (void *, const void *, const char *, unsigned));

static int
back_node(const struct fpnode_type *fpnode_data, void *back,
	  int (*call) (void *, const void *, const char *, unsigned))
{
    int delete;
    unsigned note;

    note = fpnode_data->data.call;
    if (note & 255) {
	delete = back_node(fpnode_data(fpnode_data)[0], back, call);
	if (delete) {
	} else {
	    delete = back_node(fpnode_data(fpnode_data)[1], back, call);
	}
    } else {
	delete =
	    call(back, *(const void **) (fpnode_data + 1),
		 *(const char **) ((void **) (fpnode_data + 1) + 1),
		 note >> 8);
    }

    return delete;
}


int
x1f4_span_s5deck(void *s5deck, void *back,
		 int (*call) (void *, const void *, const char *, unsigned))
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = s5deck(s5deck)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	delete = back_node(fpnode_data, back, call);
    } else {
	delete = 0;
    }

    return delete;
}
